/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2403;
import net.minecraft.class_2456;
import net.minecraft.class_2960;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ElvenTradeProvider extends BotaniaRecipeProvider {
	public ElvenTradeProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public void registerRecipes(Consumer<net.minecraft.class_2444> consumer) {
		consumer.accept(new FinishedRecipe(id("dreamwood_log"), new class_1799(BotaniaBlocks.dreamwoodLog), class_1856.method_8091(BotaniaBlocks.livingwoodLog)));
		consumer.accept(new FinishedRecipe(id("dreamwood"), new class_1799(BotaniaBlocks.dreamwood), class_1856.method_8091(BotaniaBlocks.livingwood)));

		class_1856 manaDiamond = class_1856.method_8106(BotaniaTags.Items.GEMS_MANA_DIAMOND);
		class_1856 manaSteel = class_1856.method_8106(BotaniaTags.Items.INGOTS_MANASTEEL);
		consumer.accept(new FinishedRecipe(id("elementium"), new class_1799(BotaniaItems.elementium), manaSteel, manaSteel));
		consumer.accept(new FinishedRecipe(id("elementium_block"), new class_1799(BotaniaBlocks.elementiumBlock), class_1856.method_8091(BotaniaBlocks.manasteelBlock), class_1856.method_8091(BotaniaBlocks.manasteelBlock)));

		consumer.accept(new FinishedRecipe(id("pixie_dust"), new class_1799(BotaniaItems.pixieDust), class_1856.method_8091(BotaniaItems.manaPearl)));
		consumer.accept(new FinishedRecipe(id("dragonstone"), new class_1799(BotaniaItems.dragonstone), manaDiamond));
		consumer.accept(new FinishedRecipe(id("dragonstone_block"), new class_1799(BotaniaBlocks.dragonstoneBlock), class_1856.method_8091(BotaniaBlocks.manaDiamondBlock)));

		consumer.accept(new FinishedRecipe(id("elf_quartz"), new class_1799(BotaniaItems.elfQuartz), class_1856.method_8091(class_1802.field_8155)));
		consumer.accept(new FinishedRecipe(id("elf_glass"), new class_1799(BotaniaBlocks.elfGlass), class_1856.method_8091(BotaniaBlocks.manaGlass)));

		consumer.accept(new FinishedRecipe(id("iron_return"), new class_1799(class_1802.field_8620), class_1856.method_8091(class_1802.field_8620)));
		consumer.accept(new FinishedRecipe(id("iron_block_return"), new class_1799(class_2246.field_10085), class_1856.method_8091(class_2246.field_10085)));
		consumer.accept(new FinishedRecipe(id("ender_pearl_return"), new class_1799(class_1802.field_8634), class_1856.method_8091(class_1802.field_8634)));
		consumer.accept(new FinishedRecipe(id("diamond_return"), new class_1799(class_1802.field_8477), class_1856.method_8091(class_1802.field_8477)));
		consumer.accept(new FinishedRecipe(id("diamond_block_return"), new class_1799(class_2246.field_10201), class_1856.method_8091(class_2246.field_10201)));

		class_2456.method_10476(BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER).method_10475(consumer, id("lexicon_elven").toString());
	}

	private static class_2960 id(String path) {
		return prefix("elven_trade/" + path);
	}

	@Override
	public String method_10321() {
		return "Botania elven trade recipes";
	}

	protected static class FinishedRecipe implements net.minecraft.class_2444 {
		private final class_2960 id;
		private final List<class_1856> inputs;
		private final List<class_1799> outputs;

		public FinishedRecipe(class_2960 id, class_1799 output, class_1856... inputs) {
			this(id, Arrays.asList(inputs), Collections.singletonList(output));
		}

		protected FinishedRecipe(class_2960 id, List<class_1856> inputs, List<class_1799> outputs) {
			this.id = id;
			this.inputs = inputs;
			this.outputs = outputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			JsonArray in = new JsonArray();
			for (class_1856 ingr : inputs) {
				in.add(ingr.method_8089());
			}

			JsonArray out = new JsonArray();
			for (class_1799 s : outputs) {
				out.add(ItemNBTHelper.serializeStack(s));
			}

			json.add("ingredients", in);
			json.add("output", out);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
