/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import vazkii.botania.mixin.RecipeProviderAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class BotaniaRecipeProvider implements class_2405 {
	private final class_2403 generator;

	protected BotaniaRecipeProvider(class_2403 generator) {
		this.generator = generator;
	}

	// [VanillaCopy] RecipeProvider
	@Override
	public void method_10319(class_7403 cache) {
		Path path = this.generator.method_10313();
		Set<class_2960> set = Sets.newHashSet();
		registerRecipes((recipeJsonProvider) -> {
			if (!set.add(recipeJsonProvider.method_10417())) {
				throw new IllegalStateException("Duplicate recipe " + recipeJsonProvider.method_10417());
			} else {
				RecipeProviderAccessor.callSaveRecipe(cache, recipeJsonProvider.method_17799(), path.resolve("data/" + recipeJsonProvider.method_10417().method_12836() + "/recipes/" + recipeJsonProvider.method_10417().method_12832() + ".json"));
				JsonObject jsonObject = recipeJsonProvider.method_10415();
				if (jsonObject != null) {
					XplatAbstractions.INSTANCE.saveRecipeAdvancement(this.generator, cache, jsonObject, path.resolve("data/" + recipeJsonProvider.method_10417().method_12836() + "/advancements/" + recipeJsonProvider.method_10418().method_12832() + ".json"));
				}
			}
		});
	}

	protected abstract void registerRecipes(Consumer<class_2444> consumer);
}
