/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibMisc;

import java.util.Comparator;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2471;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_6862;

import static vazkii.botania.common.item.BotaniaItems.*;

public class ItemTagProvider extends class_2471 {
	public ItemTagProvider(class_2403 generatorIn, BlockTagProvider blockTagProvider) {
		super(generatorIn, blockTagProvider);
	}

	@Override
	protected void method_10514() {
		this.method_10505(class_3481.field_15463, class_3489.field_15529);
		this.method_10505(class_3481.field_15469, class_3489.field_15535);
		this.method_10505(class_3481.field_15471, class_3489.field_15537);
		this.method_10505(class_3481.field_15468, class_3489.field_15534);
		this.method_10505(class_3481.field_15459, class_3489.field_15526);
		this.method_10505(class_3481.field_15502, class_3489.field_15557);
		this.method_10505(class_3481.field_15504, class_3489.field_15560);
		this.method_10505(class_3481.field_16584, class_3489.field_16585);
		this.method_10505(class_3481.field_17619, class_3489.field_17620);

		this.method_10505(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS, BotaniaTags.Items.MUNDANE_FLOATING_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS, BotaniaTags.Items.SPECIAL_FLOATING_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.FLOATING_FLOWERS, BotaniaTags.Items.FLOATING_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS, BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.MYSTICAL_FLOWERS, BotaniaTags.Items.MYSTICAL_FLOWERS);

		this.method_10505(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS, BotaniaTags.Items.MISC_SPECIAL_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS, BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS, BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.SPECIAL_FLOWERS, BotaniaTags.Items.SPECIAL_FLOWERS);
		this.method_10505(BotaniaTags.Blocks.MINI_FLOWERS, BotaniaTags.Items.MINI_FLOWERS);
		this.method_10512(BotaniaTags.Items.CONTRIBUTOR_HEADFLOWERS)
				.method_26792(BotaniaTags.Items.SPECIAL_FLOWERS)
				.method_26795(BotaniaBlocks.motifDaybloom.method_8389(), BotaniaBlocks.motifNightshade.method_8389());

		this.method_10512(class_3489.field_20343).method_26792(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS);
		this.method_10512(class_3489.field_15543).method_26792(BotaniaTags.Items.MYSTICAL_FLOWERS).method_26792(BotaniaTags.Items.SPECIAL_FLOWERS);

		this.method_10512(BotaniaTags.Items.BURST_VIEWERS).method_26793(monocle);
		this.method_10512(BotaniaTags.Items.TERRA_PICK_BLACKLIST).method_26795(auraRing, auraRingGreater, terrasteelHelm, spark);
		class_2474.class_5124<class_1792> builder = this.method_10512(BotaniaTags.Items.LENS);
		class_2378.field_11142.method_10220().filter(i -> i instanceof LensItem && class_2378.field_11142.method_10221(i).method_12836().equals(LibMisc.MOD_ID))
				.sorted(Comparator.comparing(class_2378.field_11142::method_10221))
				.forEach(builder::method_26793);

		this.method_10512(class_3489.field_24481).method_26795(BotaniaBlocks.alchemyCatalyst.method_8389(), divaCharm,
				BotaniaBlocks.hourglass.method_8389(), BotaniaBlocks.manaPylon.method_8389(), monocle);
		this.method_10512(class_3489.field_15541).method_26795(recordGaia1, recordGaia2);
		this.method_10512(class_3489.field_29544).method_26795(manasteelPick, elementiumPick, terraPick, glassPick);

		this.method_10512(BotaniaTags.Items.DUSTS_MANA).method_26793(manaPowder);

		this.method_10512(BotaniaTags.Items.GEMS_DRAGONSTONE).method_26793(dragonstone);
		this.method_10512(BotaniaTags.Items.GEMS_MANA_DIAMOND).method_26793(manaDiamond);

		this.method_10512(BotaniaTags.Items.INGOTS_ELEMENTIUM).method_26793(elementium);
		this.method_10512(BotaniaTags.Items.INGOTS_MANASTEEL).method_26793(manaSteel);
		this.method_10512(BotaniaTags.Items.INGOTS_TERRASTEEL).method_26793(terrasteel);

		this.method_10512(BotaniaTags.Items.NUGGETS_ELEMENTIUM).method_26793(elementiumNugget);
		this.method_10512(BotaniaTags.Items.NUGGETS_MANASTEEL).method_26793(manasteelNugget);
		this.method_10512(BotaniaTags.Items.NUGGETS_TERRASTEEL).method_26793(terrasteelNugget);

		this.method_10505(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM, BotaniaTags.Items.BLOCKS_ELEMENTIUM);
		this.method_10505(BotaniaTags.Blocks.BLOCKS_MANASTEEL, BotaniaTags.Items.BLOCKS_MANASTEEL);
		this.method_10505(BotaniaTags.Blocks.BLOCKS_TERRASTEEL, BotaniaTags.Items.BLOCKS_TERRASTEEL);

		this.method_10505(class_3481.field_23210, class_3489.field_23212);
		this.method_10505(BotaniaTags.Blocks.LIVINGWOOD_LOGS, BotaniaTags.Items.LIVINGWOOD_LOGS);
		this.method_10505(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, BotaniaTags.Items.LIVINGWOOD_LOGS_GLIMMERING);
		this.method_10505(BotaniaTags.Blocks.DREAMWOOD_LOGS, BotaniaTags.Items.DREAMWOOD_LOGS);
		this.method_10505(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING, BotaniaTags.Items.DREAMWOOD_LOGS_GLIMMERING);

		this.method_10512(class_3489.field_15532);
		this.method_10512(BotaniaTags.Items.DISPOSABLE).method_26795(class_1802.field_8831, class_1802.field_8110, class_1802.field_20412,
				class_1802.field_8328, class_1802.field_29025, class_1802.field_20399)
				.method_26792(class_3489.field_15532);
		this.method_10512(BotaniaTags.Items.SEMI_DISPOSABLE).method_26795(class_1802.field_20407, class_1802.field_20401, class_1802.field_20394,
				class_1802.field_27021, class_1802.field_27020, class_1802.field_20391, class_1802.field_22000,
				class_1802.field_28866, class_1802.field_28043, class_1802.field_28042, class_1802.field_28654,
				class_1802.field_20384, class_1802.field_20408)
				.method_35922(new class_2960("quark", "jasper"))
				.method_35922(new class_2960("quark", "limestone"))
				.method_35922(new class_2960("quark", "marble"))
				.method_35922(new class_2960("quark", "slate"));

		this.method_10512(BotaniaTags.Items.RUNES).method_26795(
				runeWater, runeFire, runeEarth, runeAir,
				runeSpring, runeSummer, runeAutumn, runeWinter,
				runeMana, runeLust, runeGluttony, runeGreed,
				runeSloth, runeWrath, runeEnvy, runePride
		);

		class_5124<class_1792> allPetals = this.method_10512(BotaniaTags.Items.PETALS);
		for (class_1767 color : class_1767.values()) {
			var petalTag = BotaniaTags.Items.getPetalTag(color);
			this.method_10512(petalTag).method_26795(getPetal(color), BotaniaBlocks.getMushroom(color).method_8389());
			allPetals.method_26792(petalTag);
		}

		this.method_10512(BotaniaTags.Items.LOONIUM_BLACKLIST).method_26795(lexicon, overgrowthSeed,
				blackLotus, blackerLotus).method_26792(class_3489.field_15541);
		this.method_10512(BotaniaTags.Items.MAGNET_RING_BLACKLIST);
		this.method_10512(BotaniaTags.Items.RODS).method_26795(
				dirtRod,
				skyDirtRod,
				terraformRod,
				cobbleRod,
				waterRod,
				tornadoRod,
				fireRod,
				diviningRod,
				smeltRod,
				exchangeRod,
				rainbowRod,
				gravityRod,
				missileRod);
		this.method_10512(BotaniaTags.Items.MANA_USING_ITEMS).method_26795(
				bloodPendant,
				cobbleRod,
				crystalBow,
				dirtRod,
				divaCharm,
				diviningRod,
				elementiumAxe,
				elementiumBoots,
				elementiumChest,
				elementiumHelm,
				elementiumHoe,
				elementiumLegs,
				elementiumPick,
				elementiumShears,
				elementiumShovel,
				elementiumSword,
				enderHand,
				exchangeRod,
				fireRod,
				flightTiara,
				flugelEye,
				glassPick,
				goddessCharm,
				gravityRod,
				infiniteFruit,
				invisibilityCloak,
				kingKey,
				livingwoodBow,
				lokiRing,
				manasteelAxe,
				manasteelBoots,
				manasteelChest,
				manasteelHelm,
				manasteelHoe,
				manasteelLegs,
				manasteelPick,
				manasteelShears,
				manasteelShovel,
				manasteelSword,
				manaweaveBoots,
				manaweaveChest,
				manaweaveHelm,
				manaweaveLegs,
				miningRing,
				missileRod,
				rainbowRod,
				skyDirtRod,
				smeltRod,
				starSword,
				superTravelBelt,
				terraAxe,
				terraPick,
				terraSword,
				terraformRod,
				terrasteelBoots,
				terrasteelChest,
				terrasteelHelm,
				terrasteelLegs,
				thirdEye,
				thunderSword,
				tornadoRod,
				travelBelt,
				waterRing,
				waterRod
		);
		this.method_10512(class_3489.field_28041).method_26793(icePendant);

		this.method_10512(BotaniaTags.Items.SEED_APOTHECARY_REAGENT)
				.method_26795(class_1802.field_8317, class_1802.field_8309, class_1802.field_8188, class_1802.field_8706)
				.method_35923(new class_2960("forge", "seeds"));
	}
}
