/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7403;

public class FloatingFlowerModelProvider implements class_2405 {
	private final class_2403 generator;

	public FloatingFlowerModelProvider(class_2403 generator) {
		this.generator = generator;
	}

	@Override
	public void method_10319(class_7403 cache) throws IOException {
		List<class_3545<String, JsonElement>> jsons = new ArrayList<>();
		for (class_2248 b : class_2378.field_11146) {
			class_2960 id = class_2378.field_11146.method_10221(b);
			if (LibMisc.MOD_ID.equals(id.method_12836()) && b instanceof FloatingFlowerBlock) {
				String name = id.method_12832();
				String nonFloat;
				if (name.endsWith("_floating_flower")) {
					nonFloat = name.replace("_floating_flower", "_mystical_flower");
				} else {
					nonFloat = name.replace("floating_", "");
				}

				JsonObject obj = new JsonObject();
				obj.addProperty("parent", "minecraft:block/block");
				obj.addProperty("loader", ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString());
				JsonObject flower = new JsonObject();
				flower.addProperty("parent", ResourcesLib.PREFIX_MOD + "block/" + nonFloat);
				obj.add("flower", flower);
				jsons.add(new class_3545<>(name, obj));
			}
		}

		for (class_3545<String, JsonElement> pair : jsons) {
			Path blockPath = generator.method_10313().resolve("assets/" + LibMisc.MOD_ID + "/models/block/" + pair.method_15442() + ".json");
			Path itemPath = generator.method_10313().resolve("assets/" + LibMisc.MOD_ID + "/models/item/" + pair.method_15442() + ".json");
			class_2405.method_10320(cache, pair.method_15441(), blockPath);
			class_2405.method_10320(cache, pair.method_15441(), itemPath);
		}
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania floating flower models";
	}
}
