/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.*;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2466;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_3481;
import net.minecraft.class_3614;

import static vazkii.botania.common.block.BotaniaBlocks.*;
import static vazkii.botania.common.block.BotaniaFlowerBlocks.*;

public class BlockTagProvider extends class_2466 {
	public static final Predicate<class_2248> BOTANIA_BLOCK = b -> LibMisc.MOD_ID.equals(class_2378.field_11146.method_10221(b).method_12836());

	public BlockTagProvider(class_2403 generator) {
		super(generator);
	}

	@Override
	protected void method_10514() {
		method_10512(class_3481.field_15463).method_26793(BotaniaBlocks.ghostRail);
		method_10512(class_3481.field_15469).method_26795(getModBlocks(b -> b instanceof class_2482));
		method_10512(class_3481.field_15468).method_26795(getModBlocks(b -> b instanceof class_2482 && b.method_9564().method_26207() == class_3614.field_15932));
		method_10512(class_3481.field_15459).method_26795(getModBlocks(b -> b instanceof class_2510));
		method_10512(class_3481.field_15502).method_26795(getModBlocks(b -> b instanceof class_2510 && b.method_9564().method_26207() == class_3614.field_15932));
		method_10512(class_3481.field_15504).method_26795(getModBlocks(b -> b instanceof class_2544));
		method_10512(class_3481.field_16584).method_26795(getModBlocks(b -> b instanceof class_2354));
		method_10512(class_3481.field_17619).method_26795(getModBlocks(b -> b instanceof class_2354 && b.method_9564().method_26207() == class_3614.field_15932));
		method_10512(class_3481.field_25147).method_26795(getModBlocks(b -> b instanceof class_2349));
		method_10512(class_3481.field_17753).method_26793(BotaniaBlocks.infrangiblePlatform);
		method_10512(class_3481.field_17754).method_26793(BotaniaBlocks.infrangiblePlatform);

		method_10512(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(BotaniaBlocks::getFloatingFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS).method_26795(field_11482.method_10220().filter(BOTANIA_BLOCK)
				.filter(b -> b instanceof FloatingSpecialFlowerBlock)
				.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
				.toArray(class_2248[]::new)
		);

		method_10512(BotaniaTags.Blocks.FLOATING_FLOWERS).method_26792(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS)
				.method_26792(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS);

		method_10512(BotaniaTags.Blocks.MYSTICAL_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(BotaniaBlocks::getFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(BotaniaTags.Blocks.SHINY_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(BotaniaBlocks::getShinyFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(BotaniaBlocks::getDoubleFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS).method_26795(manastar, pureDaisy, bergamute);
		method_10512(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS).method_26795(
				dandelifeon, endoflame, entropinnyum,
				gourmaryllis, hydroangeas, kekimurus,
				munchdew, narslimmus, rafflowsia, rosaArcana,
				shulkMeNot, spectrolus, thermalily
		);
		method_10512(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS).method_26795(
				agricarnation, agricarnationChibi, bellethorn, bellethornChibi,
				bubbell, bubbellChibi, clayconia, clayconiaChibi,
				daffomill, dreadthorn, exoflame, fallenKanade, heiseiDream,
				hopperhock, hopperhockChibi, hyacidus, jadedAmaranthus,
				jiyuulia, jiyuuliaChibi, labellia, loonium, marimorphosis, marimorphosisChibi,
				medumone, orechid, orechidIgnem, pollidisiac, rannuncarpus, rannuncarpusChibi,
				solegnolia, solegnoliaChibi, spectranthemum, tangleberrie, tangleberrieChibi, tigerseye, vinculotus
		);
		method_10512(BotaniaTags.Blocks.SPECIAL_FLOWERS).method_26792(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS)
				.method_26792(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS)
				.method_26792(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS);

		method_10512(BotaniaTags.Blocks.MINI_FLOWERS).method_26795(
				getModBlocks(b -> XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b)
						&& field_11482.method_10221(b).method_12832().endsWith("_chibi"))
		);

		method_10512(BotaniaTags.Blocks.ENCHANTER_FLOWERS).method_26792(BotaniaTags.Blocks.MYSTICAL_FLOWERS)
				.method_26792(BotaniaTags.Blocks.SHINY_FLOWERS)
				.method_26792(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS);

		// Special flowers intentionally excluded due to unwanted behaviors with tree growth and mod compat.
		method_10512(class_3481.field_20338).method_26792(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS);
		method_10512(class_3481.field_15480).method_26792(BotaniaTags.Blocks.MYSTICAL_FLOWERS);

		method_10512(class_3481.field_15490).method_26795(BotaniaBlocks.elfGlass, BotaniaBlocks.manaGlass, BotaniaBlocks.bifrost, BotaniaBlocks.bifrostPerm);
		method_10512(class_3481.field_22275).method_26795(BotaniaBlocks.manasteelBlock, BotaniaBlocks.terrasteelBlock, BotaniaBlocks.elementiumBlock,
				BotaniaBlocks.manaDiamondBlock, BotaniaBlocks.dragonstoneBlock);

		method_10512(class_3481.field_29822).method_26795(getModBlocks(b -> b instanceof BotaniaGrassBlock));
		method_10512(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM).method_26793(BotaniaBlocks.elementiumBlock);
		method_10512(BotaniaTags.Blocks.BLOCKS_MANASTEEL).method_26793(BotaniaBlocks.manasteelBlock);
		method_10512(BotaniaTags.Blocks.BLOCKS_TERRASTEEL).method_26793(BotaniaBlocks.terrasteelBlock);

		method_10512(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE).method_26795(
				BotaniaBlocks.corporeaBlock, BotaniaBlocks.corporeaBrick, BotaniaBlocks.corporeaBrickSlab, BotaniaBlocks.corporeaBrickStairs,
				BotaniaBlocks.corporeaBrickWall, BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex,
				BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaSlab, BotaniaBlocks.corporeaStairs);

		method_10512(class_3481.field_15466); // We aren't calling vanilla's generation, so need to add a dummy so that using this below doesn't error out.
		method_10512(BotaniaTags.Blocks.TERRAFORMABLE)
				.method_26795(class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10277, class_2246.field_10340, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289)
				.method_26795(class_2246.field_10566, class_2246.field_10219, class_2246.field_10253, class_2246.field_10520, class_2246.field_10402)
				.method_26795(class_2246.field_10219, class_2246.field_10255, class_2246.field_10477)
				.method_26792(class_3481.field_15466);
		method_10512(BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST).method_26795(class_2246.field_10327, BotaniaBlocks.manaPylon, BotaniaBlocks.naturaPylon, BotaniaBlocks.gaiaPylon);
		method_10512(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST).method_26795(BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool,
				BotaniaBlocks.fabulousPool, BotaniaBlocks.terraPlate, BotaniaBlocks.runeAltar);
		method_10512(BotaniaTags.Blocks.LAPUTA_IMMOBILE);

		method_10512(BotaniaTags.Blocks.TERRA_PLATE_BASE).method_26795(BotaniaBlocks.livingrock, BotaniaBlocks.shimmerrock);

		method_10512(class_3481.field_22414).method_26793(BotaniaBlocks.solidVines);

		method_10512(class_3481.field_15471).method_26795(livingwoodPlanks, livingwoodPlanksMossy, livingwoodFramed, livingwoodPatternFramed,
				dreamwoodPlanks, dreamwoodPlanksMossy, dreamwoodFramed, dreamwoodPatternFramed, shimmerwoodPlanks);

		method_10512(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING).method_26795(livingwoodGlimmering, livingwoodLogGlimmering,
				livingwoodStrippedGlimmering, livingwoodLogStrippedGlimmering);
		method_10512(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING).method_26795(dreamwoodGlimmering, dreamwoodLogGlimmering,
				dreamwoodStrippedGlimmering, dreamwoodLogStrippedGlimmering);

		method_10512(BotaniaTags.Blocks.LIVINGWOOD_LOGS)
				.method_26795(livingwoodLog, livingwood, livingwoodLogStripped, livingwoodStripped)
				.method_26792(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING);
		method_10512(BotaniaTags.Blocks.DREAMWOOD_LOGS)
				.method_26795(dreamwoodLog, dreamwood, dreamwoodLogStripped, dreamwoodStripped)
				.method_26792(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING);
		method_10512(class_3481.field_23210).method_26792(BotaniaTags.Blocks.LIVINGWOOD_LOGS).method_26792(BotaniaTags.Blocks.DREAMWOOD_LOGS);

		method_10512(BotaniaTags.Blocks.GHOST_RAIL_BARRIER).method_26792(BotaniaTags.Blocks.DREAMWOOD_LOGS);

		method_10512(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE).method_26795(class_2246.field_10340, class_2246.field_28888, class_2246.field_10474, class_2246.field_10508, class_2246.field_10115);
		method_10512(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE).method_26795(class_2246.field_10340, class_2246.field_28888, class_2246.field_10474, class_2246.field_10508, class_2246.field_10115);

		method_10512(BotaniaTags.Blocks.WEIGHT_LENS_WHITELIST);

		method_10512(class_3481.field_25739).method_26795(
				BotaniaFluffBlocks.biomeStoneFungal, BotaniaFluffBlocks.biomeStoneFungalSlab, BotaniaFluffBlocks.biomeStoneFungalStairs, BotaniaFluffBlocks.biomeStoneFungalWall,
				BotaniaFluffBlocks.biomeBrickFungal, BotaniaFluffBlocks.biomeBrickFungalSlab, BotaniaFluffBlocks.biomeBrickFungalStairs, BotaniaFluffBlocks.biomeBrickFungalWall,
				BotaniaFluffBlocks.biomeCobblestoneFungal, BotaniaFluffBlocks.biomeCobblestoneFungalSlab, BotaniaFluffBlocks.biomeCobblestoneFungalStairs, BotaniaFluffBlocks.biomeCobblestoneFungalWall,
				BotaniaFluffBlocks.biomeChiseledBrickFungal, fungalAltar);

		method_10512(class_3481.field_15503);
		method_10512(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE).method_26792(class_3481.field_15503);

		method_10512(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE).method_26793(class_2246.field_10477);

		method_10512(BotaniaTags.Blocks.UNWANDABLE);

		registerMiningTags();
	}

	private void registerMiningTags() {
		method_10512(class_3481.field_33714).method_26795(
				getModBlocks(b -> b == cellBlock
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.PETAL_BLOCK_SUFFIX)
				)
		);
		method_10512(class_3481.field_33716).method_26795(
				getModBlocks(b -> b == enchantedSoil
						|| b instanceof FloatingFlowerBlock || b instanceof BotaniaGrassBlock)
		);
		var pickaxe = Set.of(
				alchemyCatalyst, conjurationCatalyst,
				manasteelBlock, elementiumBlock, terrasteelBlock, manaDiamondBlock, dragonstoneBlock,
				manaGlass, elfGlass, bifrostPerm,
				BotaniaFluffBlocks.managlassPane, BotaniaFluffBlocks.alfglassPane, BotaniaFluffBlocks.bifrostPane,
				runeAltar, brewery, terraPlate, distributor, manaVoid, manaDetector,
				pistonRelay, tinyPlanet, spawnerClaw,
				rfGenerator, prism, pump, sparkChanger, forestEye, enderEye,
				hourglass, starfield, blazeBlock
		);
		method_10512(class_3481.field_33715).method_26795(
				getModBlocks(b -> pickaxe.contains(b)
						|| b instanceof PetalApothecaryBlock
						|| b instanceof PylonBlock
						|| b instanceof ManaPoolBlock
						|| b instanceof RedStringBlock
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.AZULEJO_PREFIX)
						|| class_2378.field_11146.method_10221(b).method_12832().contains("corporea")
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.PAVEMENT_SUFFIX)
						|| class_2378.field_11146.method_10221(b).method_12832().contains("_quartz")
						|| (class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.METAMORPHIC_PREFIX)
								&& !(b instanceof class_2544)) // vanilla includes #wall already
						|| (class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.LIVING_ROCK)
								&& !(b instanceof class_2544)) // vanilla includes #wall already
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.SHIMMERROCK)
				)
		);
		var axe = Set.of(
				alfPortal, turntable, manaBomb, bellows, incensePlate,
				cacophonium, avatar, root, felPumpkin
		);
		method_10512(class_3481.field_33713).method_26795(
				getModBlocks(b -> axe.contains(b)
						|| b instanceof DrumBlock
						|| b instanceof OpenCrateBlock
						|| b instanceof PlatformBlock
						|| b instanceof ManaSpreaderBlock
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.LIVING_WOOD)
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.DREAM_WOOD)
						|| class_2378.field_11146.method_10221(b).method_12832().contains(LibBlockNames.SHIMMERWOOD_PLANKS)
				)
		);
	}

	@NotNull
	private class_2248[] getModBlocks(Predicate<class_2248> predicate) {
		return field_11482.method_10220().filter(BOTANIA_BLOCK.and(predicate))
				.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
				.toArray(class_2248[]::new);
	}
}
