/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.block.flower.generating.*;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_101;
import net.minecraft.class_104;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2521;
import net.minecraft.class_2756;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_65;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_85.class_86;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BlockLootProvider implements class_2405 {
	public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
	private static final class_5341.class_210 SILK_TOUCH = class_223.method_945(class_2073.class_2074.method_8973()
			.method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053(1))));
	private static final Function<class_2248, class_52.class_53> SKIP = b -> {
		throw new RuntimeException("shouldn't be executed");
	};

	private final class_2403 generator;
	private final Map<class_2248, Function<class_2248, class_52.class_53>> functionTable = new HashMap<>();

	public BlockLootProvider(class_2403 generator) {
		this.generator = generator;

		for (class_2248 b : class_2378.field_11146) {
			class_2960 id = class_2378.field_11146.method_10221(b);
			if (!LibMisc.MOD_ID.equals(id.method_12836())) {
				continue;
			}
			if (b instanceof class_2482) {
				functionTable.put(b, BlockLootProvider::genSlab);
			} else if (b instanceof BotaniaDoubleFlowerBlock) {
				functionTable.put(b, BlockLootProvider::genDoubleFlower);
			} else if (b instanceof BotaniaGrassBlock) {
				functionTable.put(b, BlockLootProvider::genAltGrass);
			} else if (id.method_12832().matches(LibBlockNames.METAMORPHIC_PREFIX + "\\w+" + "_stone")) {
				functionTable.put(b, BlockLootProvider::genMetamorphicStone);
			}
		}

		// Empty
		functionTable.put(BotaniaBlocks.bifrost, BlockLootProvider::empty);
		functionTable.put(BotaniaBlocks.cocoon, BlockLootProvider::empty);
		functionTable.put(BotaniaBlocks.fakeAir, BlockLootProvider::empty);
		functionTable.put(BotaniaBlocks.manaFlame, BlockLootProvider::empty);

		// Redirects
		functionTable.put(BotaniaBlocks.cacophonium, b -> genRegular(class_2246.field_10179));
		functionTable.put(BotaniaBlocks.enchantedSoil, b -> genRegular(class_2246.field_10566));
		functionTable.put(BotaniaBlocks.enchanter, b -> genRegular(class_2246.field_10441));

		// Special
		functionTable.put(BotaniaBlocks.cellBlock, BlockLootProvider::genCellBlock);
		functionTable.put(BotaniaBlocks.root, BlockLootProvider::genRoot);
		functionTable.put(BotaniaBlocks.solidVines, BlockLootProvider::genSolidVine);
		functionTable.put(BotaniaBlocks.tinyPotato, BlockLootProvider::genTinyPotato);

		// Flower NBT saving
		functionTable.put(BotaniaFlowerBlocks.gourmaryllis, b -> genCopyNbt(b, GourmaryllisBlockEntity.TAG_LAST_FOODS, GourmaryllisBlockEntity.TAG_LAST_FOOD_COUNT, GourmaryllisBlockEntity.TAG_STREAK_LENGTH));
		functionTable.put(BotaniaFlowerBlocks.gourmaryllisFloating, b -> genCopyNbt(b, GourmaryllisBlockEntity.TAG_LAST_FOODS, GourmaryllisBlockEntity.TAG_LAST_FOOD_COUNT, GourmaryllisBlockEntity.TAG_STREAK_LENGTH));
		functionTable.put(BotaniaFlowerBlocks.hydroangeas, b -> genCopyNbt(b, HydroangeasBlockEntity.TAG_COOLDOWN, HydroangeasBlockEntity.TAG_PASSIVE_DECAY_TICKS));
		functionTable.put(BotaniaFlowerBlocks.hydroangeasFloating, b -> genCopyNbt(b, HydroangeasBlockEntity.TAG_COOLDOWN, HydroangeasBlockEntity.TAG_PASSIVE_DECAY_TICKS));
		functionTable.put(BotaniaFlowerBlocks.munchdew, b -> genCopyNbt(b, MunchdewBlockEntity.TAG_COOLDOWN));
		functionTable.put(BotaniaFlowerBlocks.munchdewFloating, b -> genCopyNbt(b, MunchdewBlockEntity.TAG_COOLDOWN));
		functionTable.put(BotaniaFlowerBlocks.rafflowsia, b -> genCopyNbt(b, RafflowsiaBlockEntity.TAG_LAST_FLOWERS, RafflowsiaBlockEntity.TAG_LAST_FLOWER_TIMES));
		functionTable.put(BotaniaFlowerBlocks.rafflowsiaFloating, b -> genCopyNbt(b, RafflowsiaBlockEntity.TAG_LAST_FLOWERS, RafflowsiaBlockEntity.TAG_LAST_FLOWER_TIMES));
		functionTable.put(BotaniaFlowerBlocks.spectrolus, b -> genCopyNbt(b, SpectrolusBlockEntity.TAG_NEXT_COLOR));
		functionTable.put(BotaniaFlowerBlocks.spectrolusFloating, b -> genCopyNbt(b, SpectrolusBlockEntity.TAG_NEXT_COLOR));
		functionTable.put(BotaniaFlowerBlocks.thermalily, b -> genCopyNbt(b, HydroangeasBlockEntity.TAG_COOLDOWN));
		functionTable.put(BotaniaFlowerBlocks.thermalilyFloating, b -> genCopyNbt(b, HydroangeasBlockEntity.TAG_COOLDOWN));
	}

	@Override
	public void method_10319(class_7403 cache) throws IOException {
		Map<class_2960, class_52.class_53> tables = new HashMap<>();

		for (class_2248 b : class_2378.field_11146) {
			class_2960 id = class_2378.field_11146.method_10221(b);
			if (!LibMisc.MOD_ID.equals(id.method_12836())) {
				continue;
			}
			Function<class_2248, class_52.class_53> func = functionTable.getOrDefault(b, BlockLootProvider::genRegular);
			if (func != SKIP) {
				tables.put(id, func.apply(b));
			}
		}

		for (Map.Entry<class_2960, class_52.class_53> e : tables.entrySet()) {
			Path path = getPath(generator.method_10313(), e.getKey());
			class_2405.method_10320(cache, class_60.method_372(e.getValue().method_334(class_173.field_1172).method_338()), path);
		}
	}

	public static Path getPath(Path root, class_2960 id) {
		return root.resolve("data/" + id.method_12836() + "/loot_tables/blocks/" + id.method_12832() + ".json");
	}

	protected static class_52.class_53 empty(class_2248 b) {
		return class_52.method_324();
	}

	@Nullable
	protected static class_52.class_53 skip(class_2248 b) {
		return null;
	}

	protected static class_52.class_53 genCopyNbt(class_2248 b, String... tags) {
		class_79.class_80<?> entry = class_77.method_411(b);
		class_3837.class_3838 func = class_3837.method_16848(class_5646.field_27914);
		for (String tag : tags) {
			func = func.method_16856(tag, "BlockEntityTag." + tag);
		}
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry)
				.method_356(class_201.method_871())
				.method_353(func);
		return class_52.method_324().method_336(pool);
	}

	protected static class_52.class_53 genCellBlock(class_2248 b) {
		class_2073.class_2074 silkPred = class_2073.class_2074.method_8973()
				.method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053(1)));
		class_79.class_80<?> silk = class_77.method_411(b)
				.method_421(class_223.method_945(silkPred));
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1)).method_351(silk));
	}

	protected static class_52.class_53 genTinyPotato(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b)
				.method_438(class_101.method_473(class_101.class_102.field_1023));
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry)
				.method_356(class_201.method_871());
		return class_52.method_324().method_336(pool);
	}

	protected static class_52.class_53 genMetamorphicStone(class_2248 b) {
		String cobbleName = class_2378.field_11146.method_10221(b).method_12832().replaceAll("_stone", "_cobblestone");
		class_2248 cobble = class_2378.field_11146.method_17966(prefix(cobbleName)).get();
		return genSilkDrop(b, cobble);
	}

	protected static class_52.class_53 genSilkDrop(class_1935 silkDrop, class_1935 normalDrop) {
		class_79.class_80<?> cobbleDrop = class_77.method_411(normalDrop).method_421(class_201.method_871());
		class_79.class_80<?> stoneDrop = class_77.method_411(silkDrop).method_421(SILK_TOUCH);

		return class_52.method_324().method_336(
				class_55.method_347().method_352(class_44.method_32448(1))
						.method_351(stoneDrop.method_417(cobbleDrop)));
	}

	protected static class_52.class_53 genSolidVine(class_2248 b) {
		class_79.class_80<?> entry = class_83.method_428(new class_2960("blocks/vine"));
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry));
	}

	protected static class_52.class_53 genRoot(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(BotaniaItems.livingroot)
				.method_438(class_141.method_621(class_5662.method_32462(2, 4)))
				.method_438(class_104.method_478());
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry));
	}

	protected static class_52.class_53 genSlab(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b)
				.method_438(class_141.method_621(class_44.method_32448(2))
						.method_524(class_212.method_900(b).method_22584(class_4559.class_4560.method_22523().method_22525(class_2482.field_11501, class_2771.field_12682))))
				.method_438(class_104.method_478());
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry));
	}

	protected static class_52.class_53 genDoubleFlower(class_2248 b) {
		var entry = class_77.method_411(b)
				.method_421(class_201.method_871())
				.method_421(class_212.method_900(b)
						.method_22584(class_4559.class_4560.method_22523().method_22525(class_2521.field_10929, class_2756.field_12607)));
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1.0F)).method_351(entry));
	}

	protected static class_52.class_53 genAltGrass(class_2248 b) {
		class_79.class_80<?> silk = class_77.method_411(b)
				.method_421(SILK_TOUCH);
		class_79.class_80<?> dirt = class_77.method_411(class_2246.field_10566)
				.method_421(class_201.method_871());
		class_79.class_80<?> entry = class_65.method_386(silk, dirt);
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry);
		return class_52.method_324().method_336(pool);
	}

	protected static class_52.class_53 genRegular(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b);
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_32448(1)).method_351(entry)
				.method_356(class_201.method_871());
		return class_52.method_324().method_336(pool);
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania block loot tables";
	}
}
