/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlock;

/**
 * This Feature is essentially the same as vanilla's
 * {@link net.minecraft.class_3173},
 * but any of Botania's mystical flowers have a chance to be replaced with their tall variant.
 */
public class MysticalFlowerFeature extends class_3031<MysticalFlowerConfig> {
	public MysticalFlowerFeature() {
		super(MysticalFlowerConfig.CODEC);
	}

	@Override
	public boolean method_13151(@NotNull class_5821<MysticalFlowerConfig> ctx) {
		MysticalFlowerConfig config = ctx.method_33656();
		class_5281 level = ctx.method_33652();
		class_2338 pos = ctx.method_33655();
		class_2680 state = config.toPlace().method_23455(ctx.method_33654(), pos);
		if (state.method_26184(level, pos)) {
			if (state.method_26204().getClass() == BotaniaFlowerBlock.class
					&& ctx.method_33654().method_43057() < config.tallChance()) {
				if (!level.method_22347(pos.method_10084())) {
					return false;
				}

				var color = ((BotaniaFlowerBlock) state.method_26204()).color;
				var doubleFlower = BotaniaBlocks.getDoubleFlower(color);
				class_2320.method_10021(level, doubleFlower.method_9564(), pos, class_2248.field_31028);
			} else {
				level.method_8652(pos, state, class_2248.field_31028);
			}

			return true;
		} else {
			return false;
		}
	}
}
