/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.proxy;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;

import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;

public interface Proxy {
	Proxy INSTANCE = make();

	private static Proxy make() {
		if (XplatAbstractions.INSTANCE.isPhysicalClient()) {
			return new ClientProxy();
		} else {
			return new Proxy() {};
		}
	}

	default void runOnClient(Supplier<Runnable> s) {}

	@Nullable
	default class_1657 getClientPlayer() {
		return null;
	}

	default void lightningFX(class_1937 level, class_243 vectorStart, class_243 vectorEnd, float ticksPerMeter, int colorOuter, int colorInner) {
		lightningFX(level, vectorStart, vectorEnd, ticksPerMeter, System.nanoTime(), colorOuter, colorInner);
	}

	default void lightningFX(class_1937 level, class_243 vectorStart, class_243 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {

	}

	default void addBoss(GaiaGuardianEntity boss) {

	}

	default void removeBoss(GaiaGuardianEntity boss) {

	}

	default int getClientRenderDistance() {
		return 0;
	}

	/** Same as {@code world.addParticle(data, true, ...)}, but culls particles below 32 block distances. */
	default void addParticleForceNear(class_1937 world, class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {}

	default void showMultiblock(IMultiblock mb, class_2561 name, class_2338 anchor, class_2470 rot) {}

	default void clearSextantMultiblock() {}

	@Nullable
	default class_239 getClientHit() {
		return null;
	}
}
