/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.loot;

import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_79;
import net.minecraft.class_83;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class LootHandler {

	public static void lootLoad(class_2960 id, Consumer<class_55.class_56> addPool) {
		String prefix = "minecraft:chests/";
		String name = id.toString();

		if (name.startsWith(prefix)) {
			String file = name.substring(name.indexOf(prefix) + prefix.length());
			switch (file) {
				case "abandoned_mineshaft":
				case "desert_pyramid":
				case "jungle_temple":
				case "simple_dungeon":
				case "spawn_bonus_chest":
				case "stronghold_corridor":
					addPool.accept(getInjectPool(file));
					break;
				case "village/village_temple":
				case "village/village_toolsmith":
				case "village/village_weaponsmith":
					addPool.accept(getInjectPool("village_chest"));
					break;
				default:
					break;
			}
		}
	}

	private static class_55.class_56 getInjectPool(String entryName) {
		return class_55.method_347()
				.method_351(getInjectEntry(entryName, 1))
				.method_35509(class_5662.method_32462(0, 1));
	}

	private static class_79.class_80<?> getInjectEntry(String name, int weight) {
		class_2960 table = prefix("inject/" + name);
		return class_83.method_428(table)
				.method_437(weight);
	}

}
