/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class UnstableReservoirRodItem extends class_1792 {

	private static final class_2960 avatarOverlay = new class_2960(ResourcesLib.MODEL_AVATAR_MISSILE);

	private static final int COST_PER = 120;
	private static final int COST_AVATAR = 40;

	public UnstableReservoirRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
		if (!(living instanceof class_1657 player)) {
			return;
		}

		if (count != method_7881(stack) && count % (ManaItemHandler.instance().hasProficiency(player, stack) ? 1 : 2) == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST_PER, false)) {
			if (!world.field_9236 && spawnMissile(world, player, player.method_23317() + (Math.random() - 0.5 * 0.1), player.method_23318() + 2.4 + (Math.random() - 0.5 * 0.1), player.method_23321() + (Math.random() - 0.5 * 0.1))) {
				ManaItemHandler.instance().requestManaExactForTool(stack, player, COST_PER, true);
			}

			SparkleParticleData data = SparkleParticleData.sparkle(6F, 1F, 0.4F, 1F, 6);
			world.method_8406(data, player.method_23317(), player.method_23318() + 2.4, player.method_23321(), 0, 0, 0);
		}
	}

	public static boolean spawnMissile(class_1937 world, class_1309 thrower, double x, double y, double z) {
		MagicMissileEntity missile;
		if (thrower != null) {
			missile = new MagicMissileEntity(thrower, false);
		} else {
			missile = BotaniaEntities.MAGIC_MISSILE.method_5883(world);
		}

		missile.method_5814(x, y, z);
		if (missile.findTarget()) {
			if (!world.field_9236) {
				missile.method_5783(world.field_9229.method_43048(100) == 0 ? BotaniaSounds.missileFunny : BotaniaSounds.missile, 1F, 0.8F + (float) Math.random() * 0.2F);
				world.method_8649(missile);
			}

			return true;
		}
		return false;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		return class_5328.method_29282(world, player, hand);
	}

	public static class AvatarBehavior implements AvatarWieldable {
		@Override
		public void onAvatarUpdate(Avatar tile) {
			class_2586 te = (class_2586) tile;
			class_1937 world = te.method_10997();
			class_2338 pos = te.method_11016();
			ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.method_11016(), te.method_11010(), te, null);
			if (receiver.getCurrentMana() >= COST_AVATAR && tile.getElapsedFunctionalTicks() % 3 == 0 && tile.isEnabled()) {
				if (spawnMissile(world, null, pos.method_10263() + 0.5 + (Math.random() - 0.5 * 0.1), pos.method_10264() + 2.5 + (Math.random() - 0.5 * 0.1), pos.method_10260() + (Math.random() - 0.5 * 0.1))) {
					if (!world.field_9236) {
						receiver.receiveMana(-COST_AVATAR);
					}
					SparkleParticleData data = SparkleParticleData.sparkle(6F, 1F, 0.4F, 1F, 6);
					world.method_8406(data, pos.method_10263() + 0.5, pos.method_10264() + 2.5, pos.method_10260() + 0.5, 0, 0, 0);
				}
			}
		}

		@Override
		public class_2960 getOverlayResource(Avatar tile) {
			return avatarOverlay;
		}
	}
}
