/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.AvatarSkiesRodPacket;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class SkiesRodItem extends class_1792 {

	private static final class_2960 avatarOverlay = new class_2960(ResourcesLib.MODEL_AVATAR_TORNADO);

	private static final int FLY_TIME = 20;
	private static final int FALL_MULTIPLIER = 3;
	private static final int MAX_COUNTER = FLY_TIME * FALL_MULTIPLIER;
	private static final int COST = 350;

	private static final String TAG_FLYING = "flying";
	private static final String TAG_FLYCOUNTER = "flyCounter";

	public SkiesRodItem(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 ent, int slot, boolean active) {
		if (ent instanceof class_1657 player) {
			boolean damaged = getFlyCounter(stack) > 0;
			boolean held = player.method_6047() == stack || player.method_6079() == stack;

			if (damaged && !isFlying(stack)) {
				setFlyCounter(stack, getFlyCounter(stack) - 1);
			}

			if (getFlyCounter(stack) >= MAX_COUNTER) {
				setFlying(stack, false);
			} else if (isFlying(stack)) {
				if (held) {
					player.field_6017 = 0F;
					double my = ManaItemHandler.instance().hasProficiency(player, stack) ? 1.6 : 1.25;
					class_243 oldMot = player.method_18798();
					if (player.method_6128()) {
						class_243 lookDir = player.method_5720();
						player.method_18799(new class_243(lookDir.method_10216() * my, lookDir.method_10214() * my, lookDir.method_10215() * my));
					} else {
						player.method_18799(new class_243(oldMot.method_10216(), my, oldMot.method_10215()));
					}

					player.method_5783(BotaniaSounds.airRod, 1F, 1F);
					for (int i = 0; i < 5; i++) {
						WispParticleData data = WispParticleData.wisp(0.35F + (float) Math.random() * 0.1F, 0.25F, 0.25F, 0.25F);
						world.method_8406(data, player.method_23317(), player.method_23318(), player.method_23321(),
								0.2F * (float) (Math.random() - 0.5),
								-0.01F * (float) Math.random(),
								0.2F * (float) (Math.random() - 0.5));
					}
				}

				setFlyCounter(stack, getFlyCounter(stack) + FALL_MULTIPLIER);
				if (getFlyCounter(stack) == MAX_COUNTER) {
					setFlying(stack, false);
				}
			}

			if (damaged) {
				player.field_6017 = 0;
			}
		}
	}

	@Override
	public boolean method_31567(@NotNull class_1799 stack) {
		return getFlyCounter(stack) > 0;
	}

	@Override
	public int method_31569(@NotNull class_1799 stack) {
		float frac = 1 - (getFlyCounter(stack) / (float) MAX_COUNTER);
		return Math.round(13 * frac);
	}

	@Override
	public int method_31571(@NotNull class_1799 stack) {
		float frac = 1 - (getFlyCounter(stack) / (float) MAX_COUNTER);
		return class_3532.method_15369(frac / 3.0F, 1.0F, 1.0F);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int fly = getFlyCounter(stack);
		if (fly == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
			ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);
			setFlying(stack, true);
			return class_1271.method_29237(stack, world.method_8608());
		}

		return class_1271.method_22430(stack);
	}

	public static boolean isFlying(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
	}

	private void setFlying(class_1799 stack, boolean flying) {
		ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
	}

	private int getFlyCounter(class_1799 stack) {
		return stack.method_7948().method_10550(TAG_FLYCOUNTER);
	}

	private void setFlyCounter(class_1799 stack, int counter) {
		stack.method_7948().method_10569(TAG_FLYCOUNTER, counter);
	}

	public static class AvatarBehavior implements AvatarWieldable {
		@Override
		public void onAvatarUpdate(Avatar tile) {
			class_2586 te = (class_2586) tile;
			class_1937 world = te.method_10997();
			Map<UUID, Integer> cooldowns = tile.getBoostCooldowns();
			ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.method_11016(), te.method_11010(), te, null);

			if (!world.field_9236) {
				decAvatarCooldowns(cooldowns);
			}
			if (!world.field_9236 && receiver.getCurrentMana() >= COST && tile.isEnabled()) {
				int range = 5;
				int rangeY = 3;
				List<class_1657> players = world.method_18467(class_1657.class,
						new class_238(te.method_11016().method_10080(-0.5 - range, -0.5 - rangeY, -0.5 - range),
								te.method_11016().method_10080(0.5 + range, 0.5 + rangeY, 0.5 + range)));
				for (class_1657 p : players) {
					int cooldown = 0;
					if (cooldowns.containsKey(p.method_5667())) {
						cooldown = cooldowns.get(p.method_5667());
					}
					if (!p.method_5715() && cooldown <= 0) {
						if (p.method_18798().method_1033() > 0.2 && p.method_18798().method_1033() < 5 && p.method_6128()) {
							doAvatarElytraBoost(p, world);
							doAvatarMiscEffects(p, receiver);
							cooldowns.put(p.method_5667(), 20);
							te.method_5431();
						} else if (p.method_18798().method_10214() > 0.3 && p.method_18798().method_10214() < 2 && !p.method_6128()) {
							doAvatarJump(p, world);
							doAvatarMiscEffects(p, receiver);
						}
					}
				}
			}
		}

		@Override
		public class_2960 getOverlayResource(Avatar tile) {
			return avatarOverlay;
		}
	}

	public static void doAvatarElytraBoost(class_1657 p, class_1937 world) {
		class_243 lookDir = p.method_5720();
		double mult = 1.25 * Math.pow(Math.E, -0.5 * p.method_18798().method_1033());
		p.method_18800(p.method_18798().method_10216() + lookDir.method_10216() * mult,
				p.method_18798().method_10214() + lookDir.method_10214() * mult,
				p.method_18798().method_10215() + lookDir.method_10215() * mult);

		if (!world.field_9236) {
			XplatAbstractions.INSTANCE.sendToPlayer(p, new AvatarSkiesRodPacket(true));
			XplatAbstractions.INSTANCE.sendToTracking(p,
					new BotaniaEffectPacket(EffectType.AVATAR_TORNADO_BOOST,
							p.method_23317(), p.method_23318(), p.method_23321(),
							p.method_5628()));
		}
	}

	public static void doAvatarJump(class_1657 p, class_1937 world) {
		p.method_18800(p.method_18798().method_10216(), 2.8, p.method_18798().method_10215());

		if (!world.field_9236) {
			XplatAbstractions.INSTANCE.sendToPlayer(p, new AvatarSkiesRodPacket(false));
			XplatAbstractions.INSTANCE.sendToTracking(p,
					new BotaniaEffectPacket(EffectType.AVATAR_TORNADO_JUMP,
							p.method_23317(), p.method_23318(), p.method_23321(),
							p.method_5628())
			);
		}
	}

	private static void doAvatarMiscEffects(class_1657 p, ManaReceiver tile) {
		p.field_6002.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), BotaniaSounds.dash, class_3419.field_15248, 1F, 1F);
		p.method_6092(new class_1293(BotaniaMobEffects.featherfeet, 100, 0));
		tile.receiveMana(-COST);
	}

	private static void decAvatarCooldowns(Map<UUID, Integer> cooldownTag) {
		for (UUID key : cooldownTag.keySet()) {
			int val = cooldownTag.get(key);
			if (val > 0) {
				cooldownTag.put(key, val - 1);
			} else {
				cooldownTag.remove(key);
			}
		}
	}

	@SoftImplement("IForgeItem")
	public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
		return reequipAnimation(oldStack, newStack);
	}

	@SoftImplement("FabricItem")
	public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
		return reequipAnimation(oldStack, newStack);
	}

	private boolean reequipAnimation(class_1799 before, class_1799 after) {
		return !before.method_31574(this) || isFlying(before) != isFlying(after);
	}

}
