/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;

public class SeasRodItem extends class_1792 {

	public static final int COST = 75;

	public SeasRodItem(class_1793 props) {
		super(props);
	}

	// [VanillaCopy] BucketItem, placement case
	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, @NotNull class_1268 interactionHand) {
		class_1799 itemStack = player.method_5998(interactionHand);
		class_3965 blockHitResult = method_7872(level, player, class_3959.class_242.field_1348);
		if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
			return class_1271.method_22430(itemStack);
		} else if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
			return class_1271.method_22430(itemStack);
		} else {
			class_2338 blockPos = blockHitResult.method_17777();
			class_2350 direction = blockHitResult.method_17780();
			class_2338 blockPos2 = blockPos.method_10093(direction);
			if (level.method_8505(player, blockPos) && player.method_7343(blockPos2, direction, itemStack)) {
				class_2680 blockState;
				blockState = level.method_8320(blockPos);
				class_2338 blockPos3 = blockState.method_26204() instanceof class_2402 ? blockPos : blockPos2;
				// Botania - consume mana
				boolean success =
						ManaItemHandler.instance().requestManaExactForTool(itemStack, player, COST, true)
								&& ((class_1755) class_1802.field_8705).method_7731(player, level, blockPos3, blockHitResult);
				if (success) {
					// No extra content for water buckets - this.checkExtraContent(player, level, itemStack, blockPos3);
					if (player instanceof class_3222 serverPlayer) {
						class_174.field_1191.method_9087(serverPlayer, blockPos3, itemStack);
					}

					player.method_7259(class_3468.field_15372.method_14956(this));
					// Botania - particles
					SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.2F, 0.2F, 1F, 5);
					for (int i = 0; i < 6; i++) {
						player.field_6002.method_8406(data, blockPos3.method_10263() + Math.random(), blockPos3.method_10264() + Math.random(), blockPos3.method_10260() + Math.random(), 0, 0, 0);
					}
					return class_1271.method_29237(itemStack, level.method_8608());
				} else {
					return class_1271.method_22431(itemStack);
				}
			} else {
				return class_1271.method_22431(itemStack);
			}
		}
	}

	@Override
	public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
		if (action != class_5536.field_27014) {
			return false;
		}
		class_1799 other = slot.method_7677();
		if (other.method_31574(class_1802.field_8550) && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true)) {
			if (other.method_7947() == 1) {
				slot.method_7673(new class_1799(class_1802.field_8705));
			} else {
				other.method_7934(1);
				player.method_31548().method_7398(new class_1799(class_1802.field_8705));
			}
			return true;
		}

		return false;
	}

	@Override
	public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
		if (action != class_5536.field_27014) {
			return false;
		}
		if (other.method_31574(class_1802.field_8550) && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true)) {
			if (other.method_7947() == 1) {
				access.method_32332(new class_1799(class_1802.field_8705));
			} else {
				other.method_7934(1);
				player.method_31548().method_7398(new class_1799(class_1802.field_8705));
			}
			return true;
		}

		return false;
	}
}
