/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_5328;

public class MoltenCoreRodItem extends class_1792 {

	private static final int TIME = 10;
	private static final int COST = 300;
	private static final int COST_PER_TICK = COST / TIME;

	public static final Map<class_1657, SmeltData> playerData = new WeakHashMap<>();

	public MoltenCoreRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		return class_5328.method_29282(world, player, hand);
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int time) {
		if (!(living instanceof class_1657 p)) {
			return;
		}
		class_1263 dummyInv = new class_1277(1);

		if (!ManaItemHandler.instance().requestManaExactForTool(stack, p, COST_PER_TICK, false)) {
			return;
		}

		class_3965 pos = ToolCommons.raytraceFromEntity(p, 32, false);

		if (pos.method_17783() == class_239.class_240.field_1332) {
			class_2680 state = world.method_8320(pos.method_17777());

			dummyInv.method_5447(0, new class_1799(state.method_26204()));
			world.method_8433().method_8132(class_3956.field_17546, dummyInv, p.field_6002)
					.map(r -> r.method_8116(dummyInv))
					.filter(r -> !r.method_7960() && r.method_7909() instanceof class_1747)
					.ifPresent(result -> {
						boolean decremented = false;

						if (playerData.containsKey(p)) {
							SmeltData data = playerData.get(p);

							if (data.equalPos(pos)) {
								data.progress--;
								decremented = true;
								if (data.progress <= 0) {
									if (!world.field_9236) {
										world.method_8501(pos.method_17777(), class_2248.method_9503(result.method_7909()).method_9564());
										world.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), BotaniaSounds.smeltRod, class_3419.field_15248, 1F, 1F);
										world.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), BotaniaSounds.smeltRod2, class_3419.field_15248, 1F, 1F);

										ManaItemHandler.instance().requestManaExactForTool(stack, p, COST_PER_TICK, true);
										playerData.remove(p);
										decremented = false;
									}

									WispParticleData data1 = WispParticleData.wisp(0.5F, 1F, 0.2F, 0.2F, 1);
									for (int i = 0; i < 25; i++) {
										double x = pos.method_17777().method_10263() + Math.random();
										double y = pos.method_17777().method_10264() + Math.random();
										double z = pos.method_17777().method_10260() + Math.random();
										world.method_8406(data1, x, y, z, 0, (float) -Math.random() / 10F, 0);
									}
								}
							}
						}

						if (!decremented) {
							playerData.put(p, new SmeltData(pos, ManaItemHandler.instance().hasProficiency(p, stack) ? (int) (TIME * 0.6) : TIME));
						} else {
							for (int i = 0; i < 2; i++) {
								double x = pos.method_17777().method_10263() + Math.random();
								double y = pos.method_17777().method_10264() + Math.random();
								double z = pos.method_17777().method_10260() + Math.random();
								WispParticleData data = WispParticleData.wisp(0.5F, 1F, 0.2F, 0.2F, 1);
								world.method_8406(data, x, y, z, 0, (float) Math.random() / 10F, 0);
							}
							if (time % 10 == 0) {
								world.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), BotaniaSounds.smeltRodSimmer, class_3419.field_15248, (float) Math.random() / 2F + 0.5F, 1F);
							}
						}
					});
		}
	}

	static class SmeltData {
		public final class_3965 pos;
		public int progress;

		public SmeltData(class_3965 pos, int progress) {
			this.pos = pos;
			this.progress = progress;
		}

		public boolean equalPos(class_3965 pos) {
			return pos.method_17777().equals(this.pos.method_17777());
		}
	}
}
