/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BifrostBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.material.SelfReturningItem;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class BifrostRodItem extends SelfReturningItem {

	private static final class_2960 avatarOverlay = new class_2960(ResourcesLib.MODEL_AVATAR_RAINBOW);

	private static final int MANA_COST = 750;
	private static final int MANA_COST_AVATAR = 4;
	private static final int TIME = 600;

	public BifrostRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!world.field_9236 && ManaItemHandler.instance().requestManaExactForTool(stack, player, MANA_COST, false)) {
			class_2680 bifrost = BotaniaBlocks.bifrost.method_9564();
			class_243 vector = player.method_5720().method_1029();

			double x = player.method_23317();
			double y = player.method_23318() - 1;
			double z = player.method_23321();
			class_2338.class_2339 pos = new class_2338.class_2339((int) x, (int) y, (int) z);

			double lastX = 0;
			double lastY = -1;
			double lastZ = 0;
			class_2338.class_2339 previousPos = new class_2338.class_2339();

			int count = 0;
			boolean placedAny = false;

			boolean prof = ManaItemHandler.instance().hasProficiency(player, stack);
			int maxlen = prof ? 160 : 100;
			int time = prof ? (int) (TIME * 1.6) : TIME;

			class_2338.class_2339 placePos = new class_2338.class_2339();

			while (count < maxlen) {
				previousPos.method_10102(lastX, lastY, lastZ);

				if (!previousPos.equals(pos)) { // Occasionally moving to the next segment stays on the same location, skip it
					if (!world.method_22347(pos) && world.method_8320(pos) != bifrost && count >= 4) {
						break; // Stop placing if you hit a wall (bifrost blocks are fine), but only after 4 segments.
					}
					if (world.method_31601(pos.method_10264())) {
						break;
					}
					if (placeBridgeSegment(world, pos, placePos, time)) {
						placedAny = true;
					}
				}

				count++;

				lastX = x;
				lastY = y;
				lastZ = z;

				x += vector.field_1352;
				y += vector.field_1351;
				z += vector.field_1350;
				pos.method_10102(x, y, z);
			}

			if (placedAny) {
				world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.bifrostRod, class_3419.field_15248, 1F, 1F);
				ManaItemHandler.instance().requestManaExactForTool(stack, player, MANA_COST, false);
				player.method_7357().method_7906(this, player.method_7337() ? 10 : TIME);
			}
		}

		return class_1271.method_29237(stack, world.method_8608());
	}

	private static boolean placeBridgeSegment(class_1937 world, class_2338 center, class_2338.class_2339 placePos, int time) {
		class_2680 bifrost = BotaniaBlocks.bifrost.method_9564();
		boolean placed = false;

		for (int i = -1; i <= 1; i++) {
			for (int j = -1; j <= 1; j++) {
				placePos.method_10103(center.method_10263() + i, center.method_10264(), center.method_10260() + j);
				if (world.method_22347(placePos) || world.method_8320(placePos) == bifrost) {
					world.method_8652(placePos, bifrost, class_2248.field_31028);

					BifrostBlockEntity tile = (BifrostBlockEntity) world.method_8321(placePos);
					if (tile != null) {
						tile.ticks = time;
						placed = true;
					}
				}
			}
		}
		return placed;
	}

	public static class AvatarBehavior implements AvatarWieldable {
		@Override
		public void onAvatarUpdate(Avatar tile) {
			class_2586 te = (class_2586) tile;
			class_1937 world = te.method_10997();
			ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.method_11016(), te.method_11010(), te, null);

			if (world.field_9236 || receiver.getCurrentMana() < MANA_COST_AVATAR * 25
					|| !tile.isEnabled() || world.method_31601(te.method_11016().method_10264() - 1)) {
				return;
			}

			class_2338 tePos = te.method_11016();
			int w = 1;
			int h = 1;
			int l = 20;

			class_238 axis = null;
			switch (world.method_8320(tePos).method_11654(class_2741.field_12481)) {
				case field_11043 -> axis = new class_238(tePos.method_10069(-w, -h, -l), tePos.method_10069(w + 1, h, 0));
				case field_11035 -> axis = new class_238(tePos.method_10069(-w, -h, 1), tePos.method_10069(w + 1, h, l + 1));
				case field_11039 -> axis = new class_238(tePos.method_10069(-l, -h, -w), tePos.method_10069(0, h, w + 1));
				case field_11034 -> axis = new class_238(tePos.method_10069(1, -h, -w), tePos.method_10069(l + 1, h, w + 1));
				default -> {}
			}

			List<class_1657> players = world.method_18467(class_1657.class, axis);
			for (class_1657 p : players) {
				int px = class_3532.method_15357(p.method_23317());
				int py = class_3532.method_15357(p.method_23318()) - 1;
				int pz = class_3532.method_15357(p.method_23321());
				int dist = 5;
				int diff = dist / 2;

				for (int i = 0; i < dist; i++) {
					for (int j = 0; j < dist; j++) {
						int ex = px + i - diff;
						int ez = pz + j - diff;

						if (!axis.method_1006(new class_243(ex + 0.5, py + 1, ez + 0.5))) {
							continue;
						}
						class_2338 pos = new class_2338(ex, py, ez);
						class_2680 state = world.method_8320(pos);
						if (state.method_26215()) {
							if (world.method_8501(pos, BotaniaBlocks.bifrost.method_9564())) {
								BifrostBlockEntity bifrostBlockEntity = (BifrostBlockEntity) world.method_8321(pos);
								bifrostBlockEntity.ticks = 10;
								receiver.receiveMana(-MANA_COST_AVATAR);
							}
						} else if (state.method_27852(BotaniaBlocks.bifrost)) {
							BifrostBlockEntity bifrostBlockEntity = (BifrostBlockEntity) world.method_8321(pos);
							if (bifrostBlockEntity.ticks < 2) {
								bifrostBlockEntity.ticks += 10;
								receiver.receiveMana(-MANA_COST_AVATAR);
							}
						}
					}
				}
			}

		}

		@Override
		public class_2960 getOverlayResource(Avatar tile) {
			return avatarOverlay;
		}
	}

}
