/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_5134;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class RingOfOdinItem extends RelicBaubleItem {

	private static final Set<String> damageNegations = new HashSet<>();

	public RingOfOdinItem(class_1793 props) {
		super(props);

		damageNegations.add(class_1282.field_5859.field_5841);
		damageNegations.add(class_1282.field_5868.field_5841);
		damageNegations.add(class_1282.field_5855.field_5841);
		damageNegations.add(class_1282.field_5852.field_5841);
		damageNegations.add(class_1282.field_5843.field_5841);
	}

	@Override
	public void onValidPlayerWornTick(class_1657 player) {
		if (player.method_5809()) {
			player.method_5646();
		}
	}

	@Override
	public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
		Multimap<class_1320, class_1322> attributes = HashMultimap.create();
		attributes.put(class_5134.field_23716,
				new class_1322(getBaubleUUID(stack), "Odin Ring", 20, class_1322.class_1323.field_6328));
		return attributes;
	}

	public static boolean onPlayerAttacked(class_1657 player, class_1282 src) {
		return (src.method_5534() || damageNegations.contains(src.field_5841))
				&& !EquipmentHandler.findOrEmpty(BotaniaItems.odinRing, player).method_7960();
	}

	public static Relic makeRelic(class_1799 stack) {
		return new RelicImpl(stack, prefix("challenge/odin_ring"));
	}

}
