package vazkii.botania.common.item.relic;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.Relic;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class RelicImpl implements Relic {
	private static final String TAG_SOULBIND_UUID = "soulbindUUID";

	private final class_1799 stack;
	@Nullable
	private final class_2960 advancementId;

	public RelicImpl(class_1799 stack, @Nullable class_2960 advancementId) {
		this.stack = stack;
		this.advancementId = advancementId;
	}

	@Override
	public void bindToUUID(UUID uuid) {
		ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
	}

	@Nullable
	@Override
	public UUID getSoulbindUUID() {
		if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
			try {
				return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
			} catch (IllegalArgumentException ex) { // Bad UUID in tag
				ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
			}
		}

		return null;
	}

	@Nullable
	@Override
	public class_2960 getAdvancement() {
		return advancementId;
	}

	@Override
	public void tickBinding(class_1657 player) {
		if (stack.method_7960()) {
			return;
		}

		if (getSoulbindUUID() == null) {
			bindToUUID(player.method_5667());
			if (player instanceof class_3222 serverPlayer) {
				RelicBindTrigger.INSTANCE.trigger(serverPlayer, stack);
			}
		} else if (!isRightPlayer(player) && player.field_6012 % 10 == 0 && shouldDamageWrongPlayer()) {
			player.method_5643(damageSource(), 2);
		}
	}

	@Override
	public boolean isRightPlayer(class_1657 player) {
		return player.method_5667().equals(getSoulbindUUID());
	}

	private static class_1282 damageSource() {
		return new class_1282("botania-relic") {};
	}

	public static void addDefaultTooltip(class_1799 stack, List<class_2561> tooltip) {
		var relic = XplatAbstractions.INSTANCE.findRelic(stack);
		if (relic == null) {
			return;
		}
		if (relic.getSoulbindUUID() == null) {
			tooltip.add(class_2561.method_43471("botaniamisc.relicUnbound"));
		} else {
			var player = ClientProxy.INSTANCE.getClientPlayer();
			if (player == null || !relic.isRightPlayer(player)) {
				tooltip.add(class_2561.method_43471("botaniamisc.notYourSagittarius"));
			} else {
				tooltip.add(class_2561.method_43469("botaniamisc.relicSoulbound", player.method_5477()));
			}
		}
	}
}
