/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.material;

import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.CustomApothecaryColor;

public class MysticalPetalItem extends class_1747 implements CustomApothecaryColor {
	public final class_1767 color;

	public MysticalPetalItem(class_2248 buriedPetals, class_1767 color, class_1793 props) {
		super(buriedPetals, props);
		this.color = color;
	}

	@NotNull
	@Override
	public String method_7876() {
		// Don't take name of the block
		return method_7869();
	}

	@Override
	public int getParticleColor(class_1799 stack) {
		return getPetalLikeColor(color);
	}

	// Color value that looks like the petal textures
	public static int getPetalLikeColor(class_1767 color) {
		return switch (color) {
			case field_7952 -> 0xF0FFFF;
			case field_7946 -> 0xF88A10;
			case field_7958 -> 0xDC04D7;
			case field_7951 -> 0x72C4FF;
			case field_7947 -> 0xFFF148;
			case field_7961 -> 0x62FF2C;
			case field_7954 -> 0xFB8BC7;
			case field_7944 -> 0x71747C;
			case field_7967 -> 0x9DA8A7;
			case field_7955 -> 0x34B0D0;
			case field_7945 -> 0x950BA8;
			case field_7966 -> 0x2448EB;
			case field_7957 -> 0x976405;
			case field_7942 -> 0x3AAB0D;
			case field_7964 -> 0xDD111F;
			case field_7963 -> 0x261E28;
		};
	}
}
