/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;

public class WarpLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_1937 world = entity.field_6002;

		if (world.field_9236 || pos.method_17783() != class_239.class_240.field_1332) {
			// On the client, we don't know what the force relay mappings really are,
			// so we can only pretend that we just hit a normal block.
			return shouldKill;
		}

		class_2338 hit = ((class_3965) pos).method_17777();
		if (entity.field_6002.method_8320(hit).method_27852(BotaniaBlocks.pistonRelay)) {
			ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get(entity.field_6002);
			class_2338 dest = data.mapping.get(hit);

			if (dest != null) {
				entity.method_5814(dest.method_10263() + 0.5, dest.method_10264() + 0.5, dest.method_10260() + 0.5);
				burst.setCollidedAt(dest);

				burst.setWarped(true);

				return false;
			}
		}
		return shouldKill;
	}
}
