/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.*;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class LensItem extends class_1792 implements ControlLensItem, CompositableLensItem, TinyPlanetExcempt {
	public static final int PROP_NONE = 0,
			PROP_POWER = 1,
			PROP_ORIENTATION = 1 << 1,
			PROP_TOUCH = 1 << 2,
			PROP_INTERACTION = 1 << 3,
			PROP_DAMAGE = 1 << 4,
			PROP_CONTROL = 1 << 5;

	private static final String TAG_COLOR = "color";
	private static final String TAG_COMPOSITE_LENS = "compositeLens";

	private final Lens lens;
	private final int props;

	public LensItem(class_1792.class_1793 builder, Lens lens, int props) {
		super(builder);
		this.lens = lens;
		this.props = props;
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		int storedColor = getStoredColor(stack);
		if (storedColor != -1) {
			var colorName = class_2561.method_43471(storedColor == 16 ? "botania.color.rainbow" : "color.minecraft." + class_1767.method_7791(storedColor));
			class_5251 realColor = class_5251.method_27717(getLensColor(stack, world));
			stacks.add(class_2561.method_43469("botaniamisc.color", colorName).method_27694(s -> s.method_27703(realColor)));
		}

		if (lens instanceof StormLens) {
			stacks.add(class_2561.method_43471("botaniamisc.creative").method_27692(class_124.field_1080));
		}
	}

	@NotNull
	@Override
	public class_2561 method_7864(@NotNull class_1799 stack) {
		class_1799 compositeLens = getCompositeLens(stack);
		if (compositeLens.method_7960()) {
			return super.method_7864(stack);
		}
		String shortKeyA = stack.method_7922() + ".short";
		String shortKeyB = compositeLens.method_7922() + ".short";
		return class_2561.method_43469("item.botania.composite_lens", class_2561.method_43471(shortKeyA), class_2561.method_43471(shortKeyB));
	}

	@Override
	public void apply(class_1799 stack, BurstProperties props, class_1937 level) {
		int storedColor = getStoredColor(stack);
		if (storedColor != -1) {
			props.color = getLensColor(stack, level);
		}

		getLens(stack).apply(stack, props);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof BasicLensItem lens) {
			lens.apply(compositeLens, props, level);
		}
	}

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		shouldKill = getLens(stack).collideBurst(burst, pos, isManaBlock, shouldKill, stack);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof BasicLensItem lens) {
			shouldKill = lens.collideBurst(burst, pos, isManaBlock, shouldKill, compositeLens);
		}

		return shouldKill;
	}

	@Override
	public void updateBurst(ManaBurst burst, class_1799 stack) {
		int storedColor = getStoredColor(stack);

		if (storedColor == 16 && burst.entity().field_6002.field_9236) {
			burst.setColor(getLensColor(stack, burst.entity().field_6002));
		}

		getLens(stack).updateBurst(burst, stack);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof BasicLensItem lens) {
			lens.updateBurst(burst, compositeLens);
		}
	}

	@Override
	public int getLensColor(class_1799 stack, class_1937 level) {
		int storedColor = getStoredColor(stack);

		if (storedColor == -1) {
			return 0xFFFFFF;
		}

		if (storedColor == 16) {
			if (level == null) {
				return 0xFFFFFF;
			}
			return class_3532.method_15369(level.method_8510() * 2 % 360 / 360F, 1F, 1F);
		}

		return ColorHelper.getColorValue(class_1767.method_7791(storedColor));
	}

	public static int getStoredColor(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
	}

	public static void setLensColor(class_1799 stack, int color) {
		ItemNBTHelper.setInt(stack, TAG_COLOR, color);
	}

	@Override
	public boolean doParticles(ManaBurst burst, class_1799 stack) {
		return true;
	}

	public static boolean isBlacklisted(class_1799 lens1, class_1799 lens2) {
		CompositableLensItem item1 = (CompositableLensItem) lens1.method_7909();
		CompositableLensItem item2 = (CompositableLensItem) lens2.method_7909();
		return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
	}

	public static Lens getLens(class_1799 stack) {
		if (stack.method_7909() instanceof LensItem lens) {
			return lens.lens;
		} else {
			return new Lens();
		}
	}

	@Override
	public boolean canCombineLenses(class_1799 sourceLens, class_1799 compositeLens) {
		CompositableLensItem sourceItem = (CompositableLensItem) sourceLens.method_7909();
		CompositableLensItem compositeItem = (CompositableLensItem) compositeLens.method_7909();
		if (sourceItem == compositeItem) {
			return false;
		}

		if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
			return false;
		}

		if (isBlacklisted(sourceLens, compositeLens)) {
			return false;
		}

		return true;
	}

	@Override
	public class_1799 getCompositeLens(class_1799 stack) {
		class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, true);
		if (cmp == null) {
			return class_1799.field_8037;
		} else {
			return class_1799.method_7915(cmp);
		}
	}

	@Override
	public class_1799 setCompositeLens(class_1799 sourceLens, class_1799 compositeLens) {
		if (compositeLens.method_7960()) {
			ItemNBTHelper.removeEntry(sourceLens, TAG_COMPOSITE_LENS);
		} else {
			class_2487 cmp = compositeLens.method_7953(new class_2487());
			ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
		}
		return sourceLens;
	}

	@Override
	public int getManaToTransfer(ManaBurst burst, class_1799 stack, ManaReceiver receiver) {
		return getLens(stack).getManaToTransfer(burst, stack, receiver);
	}

	@Override
	public boolean shouldPull(class_1799 stack) {
		return !stack.method_31574(BotaniaItems.lensStorm);
	}

	@Override
	public boolean isControlLens(class_1799 stack) {
		return (getProps(stack) & PROP_CONTROL) != 0;
	}

	@Override
	public boolean allowBurstShooting(class_1799 stack, ManaSpreader spreader, boolean redstone) {
		return getLens(stack).allowBurstShooting(stack, spreader, redstone);
	}

	@Override
	public void onControlledSpreaderTick(class_1799 stack, ManaSpreader spreader, boolean redstone) {
		getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
	}

	@Override
	public void onControlledSpreaderPulse(class_1799 stack, ManaSpreader spreader) {
		getLens(stack).onControlledSpreaderPulse(stack, spreader);
	}

	@Override
	public int getProps(class_1799 stack) {
		return props;
	}

	@Override
	public boolean isCombinable(class_1799 stack) {
		return !stack.method_31574(BotaniaItems.lensNormal);
	}

}
