/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.item.BotaniaItems;

public class InfluenceLens extends Lens {

	@Override
	public void updateBurst(ManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (!burst.isFake()) {
			double range = 3.5;
			class_238 bounds = new class_238(entity.method_23317() - range, entity.method_23318() - range, entity.method_23321() - range, entity.method_23317() + range, entity.method_23318() + range, entity.method_23321() + range);
			var items = entity.field_6002.method_18467(class_1542.class, bounds);
			var expOrbs = entity.field_6002.method_18467(class_1303.class, bounds);
			var arrows = entity.field_6002.method_18467(class_1665.class, bounds);
			var fallingBlocks = entity.field_6002.method_18467(class_1540.class, bounds);
			var primedTnt = entity.field_6002.method_18467(class_1541.class, bounds);
			var bursts = entity.field_6002.method_8390(class_1682.class, bounds, Predicates.instanceOf(ManaBurst.class));

			var concat = Iterables.concat(items, expOrbs, arrows, fallingBlocks, primedTnt, bursts);
			for (class_1297 movable : concat) {
				if (movable == burst) {
					continue;
				}

				if (movable instanceof ManaBurst otherBurst) {
					class_1799 lens = otherBurst.getSourceLens();
					if (!lens.method_7960() && lens.method_31574(BotaniaItems.lensInfluence)) {
						continue;
					}
				}
				movable.method_18799(entity.method_18798());
			}
		}
	}

}
