/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import vazkii.botania.api.internal.ManaBurst;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2667;
import net.minecraft.class_2674;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;

public class ForceLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (pos.method_17783() == class_239.class_240.field_1332
				&& !burst.isFake()
				&& !isManaBlock) {
			class_3965 rtr = (class_3965) pos;
			moveBlocks(entity.field_6002, rtr.method_17777().method_10093(rtr.method_17780()), rtr.method_17780().method_10153());
		}

		return shouldKill;
	}

	public static class_2680 unWaterlog(class_2680 state) {
		if (state.method_28498(class_2741.field_12508)) {
			return state.method_11657(class_2741.field_12508, false);
		} else {
			return state;
		}
	}

	// [VanillaCopy] Based on PistonBaseBlock
	public static boolean moveBlocks(class_1937 level, class_2338 pistonPos, class_2350 direction) {
		class_2674 pistonStructureResolver = new class_2674(level, pistonPos, direction, true);
		if (pistonStructureResolver.method_11537()) {
			Map<class_2338, class_2680> map = Maps.newHashMap();
			List<class_2338> positionsToPush = pistonStructureResolver.method_11541();
			List<class_2680> statesToPush = Lists.newArrayList();

			for (class_2338 posToPush : positionsToPush) {
				class_2680 state = level.method_8320(posToPush);
				statesToPush.add(state);
				map.put(posToPush, state);
			}

			List<class_2338> positionsToDestroy = pistonStructureResolver.method_11536();
			class_2680[] affectedStates = new class_2680[positionsToPush.size() + positionsToDestroy.size()];
			int affectedStatesPtr = 0;

			for (int k = positionsToDestroy.size() - 1; k >= 0; --k) {
				class_2338 posToDestroy = positionsToDestroy.get(k);
				class_2680 state = level.method_8320(posToDestroy);
				class_2586 blockEntity = state.method_31709() ? level.method_8321(posToDestroy) : null;
				class_2248.method_9610(state, level, posToDestroy, blockEntity);
				level.method_8652(posToDestroy, class_2246.field_10124.method_9564(), 18);
				if (!state.method_26164(class_3481.field_21952)) {
					level.method_31595(posToDestroy, state);
				}

				affectedStates[affectedStatesPtr++] = state;
			}

			for (int l = positionsToPush.size() - 1; l >= 0; --l) {
				class_2338 pos = positionsToPush.get(l);
				class_2680 state = level.method_8320(pos);
				pos = pos.method_10093(direction);
				map.remove(pos);
				class_2680 movingPiston = class_2246.field_10008.method_9564().method_11657(class_2667.field_12196, direction);
				level.method_8652(pos, movingPiston, 68);
				level.method_8438(class_2667.method_11489(pos, movingPiston, statesToPush.get(l), direction, true, false));
				affectedStates[affectedStatesPtr++] = state;
			}

			class_2680 air = class_2246.field_10124.method_9564();

			for (class_2338 blockPos6 : map.keySet()) {
				level.method_8652(blockPos6, air, 82);
			}

			for (Map.Entry<class_2338, class_2680> entry : map.entrySet()) {
				class_2338 blockPos7 = entry.getKey();
				class_2680 blockState8 = entry.getValue();
				blockState8.method_30102(level, blockPos7, 2);
				air.method_30101(level, blockPos7, 2);
				air.method_30102(level, blockPos7, 2);
			}

			affectedStatesPtr = 0;

			for (int m = positionsToDestroy.size() - 1; m >= 0; --m) {
				class_2680 state = affectedStates[affectedStatesPtr++];
				class_2338 posToDestroy = positionsToDestroy.get(m);
				state.method_30102(level, posToDestroy, 2);
				level.method_8452(posToDestroy, state.method_26204());
			}

			for (int n = positionsToPush.size() - 1; n >= 0; --n) {
				level.method_8452(positionsToPush.get(n), affectedStates[affectedStatesPtr++].method_26204());
			}

			if (!level.field_9236) {
				level.method_8396(null, pistonPos, class_3417.field_15134, class_3419.field_15245, 0.5F, level.field_9229.method_43057() * 0.25F + 0.6F);
			}

			return true;
		}

		return false;
	}

}
