/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import Z;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;

public class FlashLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (!entity.field_6002.field_9236 && pos.method_17783() == class_239.class_240.field_1332 && !burst.isFake() && !isManaBlock) {
			class_3965 rtr = (class_3965) pos;
			class_2338 neighborPos = rtr.method_17777().method_10093(rtr.method_17780());

			class_2680 stateAt = entity.field_6002.method_8320(rtr.method_17777());
			class_2680 neighbor = entity.field_6002.method_8320(neighborPos);

			if (stateAt.method_27852(BotaniaBlocks.manaFlame)) {
				entity.field_6002.method_8650(rtr.method_17777(), false);
			} else if (neighbor.method_26215() || neighbor.method_26207().method_15800()) {
				var fluid = entity.field_6002.method_8316(neighborPos);
				var water = fluid.method_15771() && fluid.method_15767(class_3486.field_15517);
				entity.field_6002.method_8501(neighborPos,
						BotaniaBlocks.manaFlame.method_9564().method_11657(class_2741.field_12508, water));

				if (entity.field_6002.method_8321(neighborPos) instanceof ManaFlameBlockEntity manaFlame) {
					manaFlame.setColor(burst.getColor());
				}
			}
		}

		return shouldKill;
	}

}
