/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_6088;

public class BoreLens extends Lens {
	@Override
	public boolean collideBurst(ManaBurst burst, class_239 rtr, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_1937 world = entity.field_6002;

		if (world.field_9236 || rtr.method_17783() != class_239.class_240.field_1332) {
			return false;
		}

		class_2338 collidePos = ((class_3965) rtr).method_17777();
		class_2680 state = world.method_8320(collidePos);

		class_1799 composite = ((LensItem) stack.method_7909()).getCompositeLens(stack);
		boolean warp = !composite.method_7960() && composite.method_31574(BotaniaItems.lensWarp);

		if (warp && (state.method_27852(BotaniaBlocks.pistonRelay) || state.method_27852(class_2246.field_10560) || state.method_27852(class_2246.field_10008) || state.method_27852(class_2246.field_10379))) {
			return false;
		}

		int harvestLevel = BotaniaConfig.common().harvestLevelBore();

		class_2586 tile = world.method_8321(collidePos);

		float hardness = state.method_26214(world, collidePos);
		int mana = burst.getMana();

		class_2338 source = burst.getBurstSourceBlockPos();
		if (!isManaBlock
				&& canHarvest(harvestLevel, state)
				&& hardness != -1
				&& (burst.isFake() || mana >= 24)) {
			if (!burst.hasAlreadyCollidedAt(collidePos)) {
				if (!burst.isFake()) {
					List<class_1799> items = class_2248.method_9562(state, (class_3218) world, collidePos, tile);

					world.method_8650(collidePos, false);
					if (BotaniaConfig.common().blockBreakParticles()) {
						world.method_20290(class_6088.field_31144, collidePos, class_2248.method_9507(state));
					}

					boolean sourceless = source.equals(ManaBurst.NO_SOURCE);
					boolean doWarp = warp && !sourceless;
					class_243 dropPosition;
					if (doWarp && world.method_8321(source) instanceof ManaSpreaderBlockEntity spreader) {
						class_243 sourceVec = class_243.method_24953(source);
						/* NB: this looks backwards but it's right. spreaders take rotX/rotY to respectively mean
						* "rotation *parallel* to the X and Y axes", while vanilla's methods take XRot/YRot
						* to respectively mean "rotation *around* the X and Y axes".
						* See also the ManaBurstEntity constructor.
						* TODO consider renaming our versions to match vanilla
						*/
						float xRot = spreader.getRotationY();
						float yRot = -(spreader.getRotationX() + 90F);
						class_243 inverseSpreaderDirection = ManaBurstEntity.calculateBurstVelocity(xRot, yRot).method_1029().method_22882();
						dropPosition = sourceVec.method_1019(inverseSpreaderDirection);
					} else {
						dropPosition = class_243.method_24953(collidePos);
					}

					if (world.method_8450().method_8355(class_1928.field_19392)) {
						for (class_1799 stack_ : items) {
							class_1542 itemEntity = new class_1542(world, dropPosition.field_1352, dropPosition.field_1351, dropPosition.field_1350, stack_);
							itemEntity.method_6988();
							world.method_8649(itemEntity);
						}
					}

					burst.setMana(mana - 24);
				}
			}

			shouldKill = false;
		}

		return shouldKill;
	}

	private static List<class_1799> stacks(class_1792... items) {
		return Stream.of(items).map(class_1799::new).toList();
	}

	private static final List<List<class_1799>> HARVEST_TOOLS_BY_LEVEL = List.of(
			stacks(class_1802.field_8647, class_1802.field_8406, class_1802.field_8167, class_1802.field_8876),
			stacks(class_1802.field_8387, class_1802.field_8062, class_1802.field_8431, class_1802.field_8776),
			stacks(class_1802.field_8403, class_1802.field_8475, class_1802.field_8609, class_1802.field_8699),
			stacks(class_1802.field_8377, class_1802.field_8556, class_1802.field_8527, class_1802.field_8250),
			stacks(class_1802.field_22024, class_1802.field_22025, class_1802.field_22026, class_1802.field_22023)
	);

	public static boolean canHarvest(int harvestLevel, class_2680 state) {
		return !getTool(harvestLevel, state).method_7960();
	}

	public static class_1799 getHarvestToolStack(int harvestLevel, class_2680 state) {
		return getTool(harvestLevel, state).method_7972();
	}

	private static class_1799 getTool(int harvestLevel, class_2680 state) {
		if (!state.method_29291()) {
			return HARVEST_TOOLS_BY_LEVEL.get(0).get(0);
		}

		int idx = Math.min(harvestLevel, HARVEST_TOOLS_BY_LEVEL.size() - 1);
		for (var tool : HARVEST_TOOLS_BY_LEVEL.get(idx)) {
			if (tool.method_7951(state)) {
				return tool;
			}
		}

		return class_1799.field_8037;
	}
}
