/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5632;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SequentialBreaker;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelPickaxeItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TerraShattererItem extends ManasteelPickaxeItem implements SequentialBreaker {

	private static final String TAG_ENABLED = "enabled";
	private static final String TAG_MANA = "mana";
	private static final String TAG_TIPPED = "tipped";

	private static final int MAX_MANA = Integer.MAX_VALUE;
	private static final int MANA_PER_DAMAGE = 100;

	public static final int[] LEVELS = new int[] {
			0, 10000, 1000000, 10000000, 100000000, 1000000000
	};

	private static final int[] CREATIVE_MANA = new int[] {
			10000 - 1, 1000000 - 1, 10000000 - 1, 100000000 - 1, 1000000000 - 1, MAX_MANA - 1
	};

	public TerraShattererItem(class_1793 props) {
		super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8F);
	}

	@Override
	public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> list) {
		if (method_7877(tab)) {
			for (int mana : CREATIVE_MANA) {
				class_1799 stack = new class_1799(this);
				setMana(stack, mana);
				list.add(stack);
			}
			class_1799 stack = new class_1799(this);
			setMana(stack, CREATIVE_MANA[1]);
			setTipped(stack);
			list.add(stack);
		}
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		class_2561 rank = class_2561.method_43471("botania.rank" + getLevel(stack));
		class_2561 rankFormat = class_2561.method_43469("botaniamisc.toolRank", rank);
		stacks.add(rankFormat);
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		if (manaItem != null && manaItem.getMana() == Integer.MAX_VALUE) {
			stacks.add(class_2561.method_43471("botaniamisc.getALife").method_27692(class_124.field_1061));
		}
	}

	@Override
	public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.method_21823() && hand == class_1268.field_5808) {
			int tier = getLevel(stack);
			class_3965 blockhitresult = method_7872(level, player, class_3959.class_242.field_1348);

			if (tier != 0 && blockhitresult.method_17783() != class_239.class_240.field_1332) {
				setEnabled(stack, !isEnabled(stack));
				if (!level.field_9236) {
					level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.terraPickMode, class_3419.field_15248, 1F, 1F);
				}
				return class_1271.method_29237(stack, level.method_8608());
			}
		}
		return class_1271.method_22430(stack);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		super.method_7888(stack, world, entity, slot, selected);
		if (isEnabled(stack)) {
			int level = getLevel(stack);

			if (level == 0) {
				setEnabled(stack, false);
			} else if (entity instanceof class_1657 player && !player.field_6252) {
				var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
				manaItem.addMana(-level);
			}
		}
	}

	@Override
	public Optional<class_5632> method_32346(class_1799 stack) {
		int level = getLevel(stack);
		int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
		int curr = getMana_(stack);
		float percent = level == 0 ? 0F : (float) curr / (float) max;

		return Optional.of(new ManaBarTooltip(percent, level));
	}

	@SoftImplement("IForgeItem")
	public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
		class_3965 raycast = ToolCommons.raytraceFromEntity(player, 10, false);
		if (!player.field_6002.field_9236 && raycast.method_17783() == class_239.class_240.field_1332) {
			class_2350 face = raycast.method_17780();
			breakOtherBlock(player, stack, pos, pos, face);
			if (player.method_21823()) {
				BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
			}
		}

		return false;
	}

	@Override
	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@Override
	public void breakOtherBlock(class_1657 player, class_1799 stack, class_2338 pos, class_2338 originPos, class_2350 side) {
		if (!isEnabled(stack)) {
			return;
		}

		class_1937 world = player.field_6002;
		Predicate<class_2680> canMine = state -> {
			boolean rightToolForDrops = !state.method_29291() || stack.method_7951(state);
			boolean rightToolForSpeed = stack.method_7924(state) > 1
					|| state.method_26164(class_3481.field_33716)
					|| state.method_26164(class_3481.field_33714);
			return rightToolForDrops && rightToolForSpeed;
		};

		class_2680 targetState = world.method_8320(pos);
		if (!canMine.test(targetState)) {
			return;
		}

		if (world.method_22347(pos)) {
			return;
		}

		boolean thor = !RingOfThorItem.getThorRing(player).method_7960();
		boolean doX = thor || side.method_10148() == 0;
		boolean doY = thor || side.method_10164() == 0;
		boolean doZ = thor || side.method_10165() == 0;

		int origLevel = getLevel(stack);
		int level = origLevel + (thor ? 1 : 0);
		if (StoneOfTemperanceItem.hasTemperanceActive(player) && level > 2) {
			level = 2;
		}

		int range = level - 1;
		int rangeY = Math.max(1, range);

		if (range == 0 && level != 1) {
			return;
		}

		class_2382 beginDiff = new class_2382(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
		class_2382 endDiff = new class_2382(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);

		ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, canMine);

		if (origLevel == 5) {
			PlayerHelper.grantCriterion((class_3222) player, prefix("challenge/rank_ss_pick"), "code_triggered");
		}
	}

	public static boolean isTipped(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
	}

	public static void setTipped(class_1799 stack) {
		ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
	}

	public static boolean isEnabled(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
	}

	void setEnabled(class_1799 stack, boolean enabled) {
		ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
	}

	protected static void setMana(class_1799 stack, int mana) {
		if (mana > 0) {
			ItemNBTHelper.setInt(stack, TAG_MANA, mana);
		} else {
			ItemNBTHelper.removeEntry(stack, TAG_MANA);
		}
	}

	public static int getMana_(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
	}

	public static int getLevel(class_1799 stack) {
		int mana = getMana_(stack);
		for (int i = LEVELS.length - 1; i > 0; i--) {
			if (mana >= LEVELS[i]) {
				return i;
			}
		}

		return 0;
	}

	public static class ManaItemImpl implements ManaItem {
		private final class_1799 stack;

		public ManaItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public int getMana() {
			return getMana_(stack) * stack.method_7947();
		}

		@Override
		public int getMaxMana() {
			return MAX_MANA * stack.method_7947();
		}

		@Override
		public void addMana(int mana) {
			setMana(stack, Math.min(getMana() + mana, getMaxMana()) / stack.method_7947());
		}

		@Override
		public boolean canReceiveManaFromPool(class_2586 pool) {
			return true;
		}

		@Override
		public boolean canReceiveManaFromItem(class_1799 otherStack) {
			return !otherStack.method_31573(BotaniaTags.Items.TERRA_PICK_BLACKLIST);
		}

		@Override
		public boolean canExportManaToPool(class_2586 pool) {
			return false;
		}

		@Override
		public boolean canExportManaToItem(class_1799 otherStack) {
			return false;
		}

		@Override
		public boolean isNoExport() {
			return true;
		}
	}

	@SoftImplement("IForgeItem")
	public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
		return reequipAnimation(oldStack, newStack);
	}

	@SoftImplement("FabricItem")
	public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 before, class_1799 after) {
		return reequipAnimation(before, after);
	}

	private boolean reequipAnimation(class_1799 before, class_1799 after) {
		return !after.method_31574(this) || isEnabled(before) != isEnabled(after);
	}

	@NotNull
	@Override
	public class_1814 method_7862(@NotNull class_1799 stack) {
		int level = getLevel(stack);
		if (stack.method_7942()) {
			level++;
		}
		if (level >= 5) { // SS rank/enchanted S rank
			return class_1814.field_8904;
		}
		if (level >= 3) { // A rank/enchanted B rank
			return class_1814.field_8903;
		}
		return class_1814.field_8907;
	}
}
