/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.network.serverbound.LeftClickPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_3419;
import net.minecraft.class_3966;

public class TerraBladeItem extends ManasteelSwordItem implements LensEffectItem {

	private static final int MANA_PER_DAMAGE = 100;

	public TerraBladeItem(class_1793 props) {
		super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
	}

	public static void leftClick(class_1799 stack) {
		if (!stack.method_7960() && stack.method_7909() instanceof TerraBladeItem) {
			ClientXplatAbstractions.INSTANCE.sendToServer(LeftClickPacket.INSTANCE);
		}
	}

	public static class_1269 attackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hit) {
		if (!player.field_6002.field_9236 && !player.method_7325()) {
			trySpawnBurst(player);
		}
		return class_1269.field_5811;
	}

	public static void trySpawnBurst(class_1657 player) {
		trySpawnBurst(player, player.method_7261(0F));
	}

	public static void trySpawnBurst(class_1657 player, float attackStrength) {
		if (!player.method_6047().method_7960()
				&& player.method_6047().method_31574(BotaniaItems.terraSword)
				&& attackStrength == 1) {
			ManaBurstEntity burst = getBurst(player, player.method_6047());
			player.field_6002.method_8649(burst);
			player.method_6047().method_7956(1, player, p -> p.method_20236(class_1268.field_5808));
			player.field_6002.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.terraBlade, class_3419.field_15248, 1F, 1F);
		}
	}

	@Override
	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	public static ManaBurstEntity getBurst(class_1657 player, class_1799 stack) {
		ManaBurstEntity burst = new ManaBurstEntity(player);

		float motionModifier = 7F;

		burst.setColor(0x20FF20);
		burst.setMana(MANA_PER_DAMAGE);
		burst.setStartingMana(MANA_PER_DAMAGE);
		burst.setMinManaLoss(40);
		burst.setManaLossPerTick(4F);
		burst.setGravity(0F);
		burst.method_18799(burst.method_18798().method_1021(motionModifier));

		burst.setSourceLens(stack.method_7972());
		return burst;
	}

	@Override
	public void apply(class_1799 stack, BurstProperties props, class_1937 level) {}

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		return shouldKill;
	}

	@Override
	public void updateBurst(ManaBurst burst, class_1799 stack) {
		class_1682 entity = burst.entity();
		class_238 axis = new class_238(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.field_6038, entity.field_5971, entity.field_5989).method_1014(1);
		List<class_1309> entities = entity.field_6002.method_18467(class_1309.class, axis);
		class_1297 thrower = entity.method_24921();

		for (class_1309 living : entities) {
			if (living == thrower || living instanceof class_1657 livingPlayer && thrower instanceof class_1657 throwingPlayer
					&& !throwingPlayer.method_7256(livingPlayer)) {
				continue;
			}

			if (living.field_6235 == 0) {
				int cost = MANA_PER_DAMAGE / 3;
				int mana = burst.getMana();
				if (mana >= cost) {
					burst.setMana(mana - cost);
					float damage = 4F + BotaniaAPI.instance().getTerrasteelItemTier().method_8028();
					if (!burst.isFake() && !entity.field_6002.field_9236) {
						class_1282 source = class_1282.field_5846;
						if (thrower instanceof class_1657 player) {
							source = class_1282.method_5532(player);
						} else if (thrower instanceof class_1309 livingEntity) {
							source = class_1282.method_5511(livingEntity);
						}
						living.method_5643(source, damage);
						entity.method_31472();
						break;
					}
				}
			}
		}
	}

	@Override
	public boolean doParticles(ManaBurst burst, class_1799 stack) {
		return true;
	}
}
