/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;
import vazkii.botania.mixin.LivingEntityAccessor;

import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_47.class_48;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ElementiumAxeItem extends ManasteelAxeItem {
	private static final class_2960 BEHEADING_LOOT_TABLE = prefix("elementium_axe_beheading");

	public ElementiumAxeItem(class_1793 props) {
		super(BotaniaAPI.instance().getElementiumItemTier(), props);
	}

	public static void onEntityDrops(boolean hitRecently, class_1282 source, class_1309 target,
			Consumer<class_1799> consumer) {
		var ctx = ((LivingEntityAccessor) target).callCreateLootContext(hitRecently, source);
		target.field_6002.method_8503().method_3857().method_367(BEHEADING_LOOT_TABLE)
				.method_320(ctx.method_309(class_173.field_1173), consumer);
	}

	@SoftImplement("IForgeItem")
	public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
		if (enchantment == class_1893.field_9110) {
			return true;
		} else {
			// Copy the default impl
			return enchantment.field_9083.method_8177(this);
		}

	}

}
