/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.bow;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;

public class CrystalBowItem extends LivingwoodBowItem {

	private static final int ARROW_COST = 200;

	public CrystalBowItem(class_1793 builder) {
		super(builder);
	}

	// [VanillaCopy] super
	@NotNull
	@Override
	public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, class_1657 playerIn, @NotNull class_1268 handIn) {
		class_1799 itemstack = playerIn.method_5998(handIn);
		boolean flag = canFire(itemstack, playerIn); // Botania - custom check

		if (!playerIn.method_31549().field_7477 && !flag) {
			return class_1271.method_22431(itemstack);
		} else {
			playerIn.method_6019(handIn);
			return class_1271.method_22428(itemstack);
		}
	}

	// [VanillaCopy] super
	@Override
	public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
		if (entityLiving instanceof class_1657 playerentity) {
			boolean flag = canFire(stack, playerentity); // Botania - custom check
			class_1799 itemstack = playerentity.method_18808(stack);

			int i = (int) ((method_7881(stack) - timeLeft) * chargeVelocityMultiplier()); // Botania - velocity multiplier
			if (i < 0) {
				return;
			}

			if (!itemstack.method_7960() || flag) {
				if (itemstack.method_7960()) {
					itemstack = new class_1799(class_1802.field_8107);
				}

				float f = method_7722(i);
				if (!((double) f < 0.1D)) {
					boolean flag1 = playerentity.method_31549().field_7477 || itemstack.method_31574(class_1802.field_8107);
					if (!worldIn.field_9236) {
						class_1744 arrowitem = (class_1744) (itemstack.method_7909() instanceof class_1744 ? itemstack.method_7909() : class_1802.field_8107);
						class_1665 abstractarrowentity = arrowitem.method_7702(worldIn, itemstack, playerentity);
						abstractarrowentity.method_24919(playerentity, playerentity.method_36455(), playerentity.method_36454(), 0.0F, f * 3.0F, 1.0F);
						if (f == 1.0F) {
							abstractarrowentity.method_7439(true);
						}

						int j = class_1890.method_8225(class_1893.field_9103, stack);
						if (j > 0) {
							abstractarrowentity.method_7438(abstractarrowentity.method_7448() + (double) j * 0.5D + 0.5D);
						}

						int k = class_1890.method_8225(class_1893.field_9116, stack);
						if (k > 0) {
							abstractarrowentity.method_7449(k);
						}

						if (class_1890.method_8225(class_1893.field_9126, stack) > 0) {
							abstractarrowentity.method_5639(100);
						}

						// Botania - onFire
						onFire(stack, playerentity, flag1, abstractarrowentity);
						stack.method_7956(1, playerentity, (p_220009_1_) -> {
							p_220009_1_.method_20236(playerentity.method_6058());
						});
						if (flag1 || playerentity.method_31549().field_7477 && (itemstack.method_31574(class_1802.field_8236) || itemstack.method_31574(class_1802.field_8087))) {
							abstractarrowentity.field_7572 = class_1665.class_1666.field_7594;
						}

						worldIn.method_8649(abstractarrowentity);
					}

					worldIn.method_43128((class_1657) null, playerentity.method_23317(), playerentity.method_23318(), playerentity.method_23321(),
							class_3417.field_14600, class_3419.field_15248,
							1.0F, 1.0F / (playerentity.method_6051().method_43057() * 0.4F + 1.2F) + f * 0.5F);
					if (!flag1 && !playerentity.method_31549().field_7477) {
						itemstack.method_7934(1);
						if (itemstack.method_7960()) {
							playerentity.method_31548().method_7378(itemstack);
						}
					}

					playerentity.method_7259(class_3468.field_15372.method_14956(this));
				}
			}
		}
	}

	@Override
	public float chargeVelocityMultiplier() {
		return 2F;
	}

	private boolean canFire(class_1799 stack, class_1657 player) {
		boolean infinity = class_1890.method_8225(class_1893.field_9125, stack) > 0;
		return player.method_31549().field_7477 || ManaItemHandler.instance().requestManaExactForTool(stack, player, ARROW_COST / (infinity ? 2 : 1), false);
	}

	private void onFire(class_1799 stack, class_1309 living, boolean infinity, class_1665 arrow) {
		arrow.field_7572 = class_1665.class_1666.field_7594;
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		boolean infinity = class_1890.method_8225(class_1893.field_9125, stack) > 0;
		return ToolCommons.damageItemIfPossible(stack, amount, entity, ARROW_COST / (infinity ? 2 : 1));
	}
}
