/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_6088;

public final class ToolCommons {

	private static boolean recCall = false;

	/**
	 * Consumes as much mana as possible, returning the amount of damage that couldn't be paid with mana
	 */
	public static int damageItemIfPossible(class_1799 stack, int amount, class_1309 entity, int manaPerDamage) {
		if (!(entity instanceof class_1657 player)) {
			return amount;
		}

		while (amount > 0) {
			if (ManaItemHandler.instance().requestManaExactForTool(stack, player, manaPerDamage, true)) {
				amount--;
			} else {
				break;
			}
		}

		return amount;
	}

	public static void removeBlocksInIteration(class_1657 player, class_1799 stack, class_1937 world, class_2338 centerPos,
			class_2382 startDelta, class_2382 endDelta, Predicate<class_2680> filter) {
		if (recCall) {
			return;
		}

		recCall = true;
		try {
			for (class_2338 iterPos : class_2338.method_10097(centerPos.method_10081(startDelta),
					centerPos.method_10081(endDelta))) {
				// skip original block space, vanilla code will handle it
				if (iterPos.equals(centerPos)) {
					continue;
				}
				removeBlockWithDrops(player, stack, world, iterPos, filter);
			}
		} finally {
			recCall = false;
		}
	}

	/**
	 * NB: Cannot be called in a call chain leading from PlayerInteractionManager.tryHarvestBlock
	 * without additional protection like {@link #recCall} in {@link #removeBlocksInIteration}
	 * or {@link vazkii.botania.common.item.relic.RingOfLokiItem#breakOnAllCursors},
	 * since this method calls that method also and would lead to an infinite loop.
	 */
	public static void removeBlockWithDrops(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos,
			Predicate<class_2680> filter) {
		if (!world.method_22340(pos)) {
			return;
		}

		class_2680 blockstate = world.method_8320(pos);
		boolean unminable = blockstate.method_26165(player, world, pos) == 0;

		if (!world.field_9236 && !unminable && filter.test(blockstate) && !blockstate.method_26215()) {
			class_1799 save = player.method_6047();
			player.method_6122(class_1268.field_5808, stack);
			((class_3222) player).field_13987.method_14364(
					new class_2673(class_6088.field_31144, pos, class_2248.method_9507(blockstate), false));
			((class_3222) player).field_13974.method_14266(pos);
			player.method_6122(class_1268.field_5808, save);
		}
	}

	public static int getToolPriority(class_1799 stack) {
		if (stack.method_7960()) {
			return 0;
		}

		class_1792 item = stack.method_7909();
		if (!(item instanceof class_1766 tool)) {
			return 0;
		}

		class_1832 material = tool.method_8022();
		int materialLevel = 0;
		if (material == BotaniaAPI.instance().getManasteelItemTier()) {
			materialLevel = 10;
		}
		if (material == BotaniaAPI.instance().getElementiumItemTier()) {
			materialLevel = 11;
		}
		if (material == BotaniaAPI.instance().getTerrasteelItemTier()) {
			materialLevel = 20;
		}

		int modifier = 0;
		if (stack.method_31574(BotaniaItems.terraPick)) {
			modifier = TerraShattererItem.getLevel(stack);
		}

		int efficiency = class_1890.method_8225(class_1893.field_9131, stack);
		return materialLevel * 100 + modifier * 10 + efficiency;
	}

	public static class_3965 raytraceFromEntity(class_1297 e, double distance, boolean fluids) {
		return (class_3965) e.method_5745(distance, 1, fluids);
	}
}
