/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.proxy.Proxy;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;

public class ThirdEyeItem extends BaubleItem {

	private static final int COST = 2;

	public ThirdEyeItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (!(living instanceof class_1657 eplayer)) {
			return;
		}

		double range = 24;
		class_238 aabb = new class_238(living.method_23317(), living.method_23318(), living.method_23321(), living.method_23317(), living.method_23318(), living.method_23321()).method_1014(range);
		List<class_1309> mobs = living.field_6002.method_8390(class_1309.class, aabb, MagicMissileEntity.targetPredicate(living));

		for (class_1309 e : mobs) {
			class_1293 potion = e.method_6112(class_1294.field_5912);
			if ((potion == null || potion.method_5584() <= 2) && ManaItemHandler.instance().requestManaExact(stack, eplayer, COST, true)) {
				e.method_6092(new class_1293(class_1294.field_5912, 12, 0));
			}
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6174).method_7960();

			for (int i = 0; i < 3; i++) {
				ms.method_22903();
				bipedModel.field_3391.method_22703(ms);

				switch (i) {
					case 0:
						break;
					case 1:
						double time = ClientTickHandler.total() * 0.12;
						double dist = 0.05;
						ms.method_22904(Math.sin(time) * dist, Math.cos(time * 0.5) * dist, 0);

						ms.method_22905(0.75F, 0.75F, 1F);
						ms.method_22904(0, 0.1, -0.025);
						break;
					case 2:
						ms.method_22904(0, 0, -0.05);
						break;
				}

				ms.method_22904(-0.3, 0.6, armor ? 0.10 : 0.15);
				ms.method_22905(0.6F, -0.6F, -0.6F);
				class_1087 model = MiscellaneousModels.INSTANCE.thirdEyeLayers[i];
				class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
				class_310.method_1551().method_1541().method_3350()
						.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);
				ms.method_22909();
			}
		}
	}

}
