/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5134;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.proxy.Proxy;

public class TectonicGirdleItem extends BaubleItem {

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_KNOCKBACK_BELT);

	public TectonicGirdleItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
		Multimap<class_1320, class_1322> attributes = HashMultimap.create();
		attributes.put(class_5134.field_23718, new class_1322(getBaubleUUID(stack), "Knockback Belt", 1, class_1322.class_1323.field_6328));
		return attributes;
	}

	public static class Renderer implements AccessoryRenderer {
		private static class_572<class_1309> model = null;

		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			AccessoryRenderHelper.rotateIfSneaking(ms, living);

			float s = 1.15F;
			ms.method_22905(s, s, s);
			if (model == null) {
				model = new class_572<>(class_310.method_1551()
						.method_31974().method_32072(class_5602.field_27577));
			}

			class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
			model.field_3391.method_22698(ms, buffer, light, class_4608.field_21444);
		}
	}
}
