/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.proxy.Proxy;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;

public class SpectatorItem extends BaubleItem {

	private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
	private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";

	public SpectatorItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (!(living instanceof class_1657 player)) {
			return;
		}

		if (living.field_6002.field_9236) {
			this.tickClient(stack, player);
		} else {
			this.tickServer(stack, player);
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6169).method_7960();
			bipedModel.field_3398.method_22703(ms);
			ms.method_22904(-0.35, -0.2, armor ? 0.05 : 0.1);
			ms.method_22905(0.75F, -0.75F, -0.75F);

			class_1087 model = MiscellaneousModels.INSTANCE.itemFinderGem;
			class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);
		}
	}

	protected void tickClient(class_1799 stack, class_1657 player) {
		if (player != Proxy.INSTANCE.getClientPlayer()) {
			return;
		}

		class_2499 blocks = ItemNBTHelper.getList(stack, TAG_BLOCK_POSITIONS, class_2520.field_33254, false);

		for (var block : blocks) {
			class_2338 pos = class_2338.method_10092(((class_2503) block).method_10699());
			float m = 0.02F;
			WispParticleData data = WispParticleData.wisp(0.15F + 0.05F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), false);
			player.field_6002.method_8406(data, pos.method_10263() + (float) Math.random(), pos.method_10264() + (float) Math.random(), pos.method_10260() + (float) Math.random(), m * (float) (Math.random() - 0.5), m * (float) (Math.random() - 0.5), m * (float) (Math.random() - 0.5));
		}

		int[] entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS);
		for (int i : entities) {
			class_1297 e = player.field_6002.method_8469(i);
			if (e != null && Math.random() < 0.6) {
				WispParticleData data = WispParticleData.wisp(0.15F + 0.05F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), Math.random() < 0.6);
				player.field_6002.method_8406(data, e.method_23317() + (float) (Math.random() * 0.5 - 0.25) * 0.45F, e.method_23318() + e.method_17682(), e.method_23321() + (float) (Math.random() * 0.5 - 0.25) * 0.45F, 0, 0.05F + 0.03F * (float) Math.random(), 0);
			}
		}
	}

	protected void tickServer(class_1799 stack, class_1657 player) {
		IntArrayList entPosBuilder = new IntArrayList();
		class_2499 blockPosBuilder = new class_2499();

		scanForStack(player.method_6047(), player, entPosBuilder, blockPosBuilder);
		scanForStack(player.method_6079(), player, entPosBuilder, blockPosBuilder);

		int[] currentEnts = entPosBuilder.elements();

		ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
		ItemNBTHelper.setList(stack, TAG_BLOCK_POSITIONS, blockPosBuilder);
	}

	private void scanForStack(class_1799 pstack, class_1657 player, IntArrayList entIdBuilder, class_2499 blockPosBuilder) {
		if (!pstack.method_7960() || player.method_5715()) {
			int range = 24;

			List<class_1297> entities = player.field_6002.method_18467(class_1297.class, new class_238(player.method_23317() - range, player.method_23318() - range, player.method_23321() - range, player.method_23317() + range, player.method_23318() + range, player.method_23321() + range));
			for (class_1297 e : entities) {
				if (e == player) {
					continue;
				}
				if (e instanceof class_1542 item) {
					class_1799 istack = item.method_6983();
					if (player.method_5715() || istack.method_7962(pstack) && class_1799.method_7975(istack, pstack)) {
						entIdBuilder.add(item.method_5628());
					}
				} else if (e instanceof class_1657 targetPlayer) {
					class_1263 binv = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
					if (scanInventory(targetPlayer.method_31548(), pstack) || scanInventory(binv, pstack)) {
						entIdBuilder.add(targetPlayer.method_5628());
					}

				} else if (e instanceof class_1915 villager) {
					for (class_1914 offer : villager.method_8264()) {
						if (equalStacks(pstack, offer.method_8246())
								|| equalStacks(pstack, offer.method_8247())
								|| equalStacks(pstack, offer.method_8250())) {
							entIdBuilder.add(e.method_5628());
						}
					}
				} else if (e instanceof class_1263 inv) {
					if (scanInventory(inv, pstack)) {
						entIdBuilder.add(e.method_5628());
					}
				}
			}

			if (!pstack.method_7960()) {
				range = 12;
				class_2338 pos = player.method_24515();
				for (class_2338 pos_ : class_2338.method_10097(pos.method_10069(-range, -range, -range), pos.method_10069(range + 1, range + 1, range + 1))) {
					class_2586 tile = player.field_6002.method_8321(pos_);
					if (tile != null) {
						if (tile instanceof class_1263 inv) {
							if (scanInventory(inv, pstack)) {
								blockPosBuilder.add(class_2503.method_23251(pos_.method_10063()));
							}
						}
					}
				}
			}
		}
	}

	private boolean equalStacks(class_1799 stack1, class_1799 stack2) {
		return stack1.method_7962(stack2) && class_1799.method_7975(stack1, stack2);
	}

	private boolean scanInventory(class_1263 inv, class_1799 pstack) {
		if (pstack.method_7960()) {
			return false;
		}

		for (int l = 0; l < inv.method_5439(); l++) {
			class_1799 istack = inv.method_5438(l);
			// Some mods still set stuff to null apparently...
			if (istack != null && !istack.method_7960() && equalStacks(istack, pstack)) {
				return true;
			}
		}
		return false;
	}

}
