/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1894;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_6880;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.BiomeAccessor;

public class SnowflakePendantItem extends BaubleItem {

	public SnowflakePendantItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 entity) {
		if (!entity.field_6002.field_9236 && !entity.method_5715()) {
			boolean lastOnGround = entity.method_24828();
			entity.method_24830(true);
			class_1894.method_8236(entity, entity.field_6002, entity.method_24515(), 8);
			entity.method_24830(lastOnGround);

			int x;
			int y = class_3532.method_15357(entity.method_23318());
			int z;
			class_2680 blockstate = class_2246.field_10477.method_9564();

			for (int l = 0; l < 4; ++l) {
				x = class_3532.method_15357(entity.method_23317() + (double) ((float) (l % 2 * 2 - 1) * 0.25F));
				z = class_3532.method_15357(entity.method_23321() + (double) ((float) (l / 2 % 2 * 2 - 1) * 0.25F));
				class_2338 blockpos = new class_2338(x, y, z);

				if (entity.field_6002.method_22347(blockpos) && blockstate.method_26184(entity.field_6002, blockpos)) {
					var biome = entity.field_6002.method_23753(blockpos);
					if (((BiomeAccessor) (Object) biome.comp_349()).callGetTemperature(blockpos) < 0.9F) {
						entity.field_6002.method_8501(blockpos, blockstate);
					}
				}
			}
		} else if (entity.field_6002.field_9236 && !entity.method_5715()) {
			if (entity.field_6002.field_9229.method_43057() >= 0.25F) {
				entity.field_6002.method_8406(new class_2388(class_2398.field_11206, class_2246.field_10491.method_9564()), entity.method_23317() + entity.field_6002.field_9229.method_43057() * 0.6 - 0.3, entity.method_23318() + 1.1, entity.method_23321() + entity.field_6002.field_9229.method_43057() * 0.6 - 0.3, 0, -0.15, 0);
			}
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6174).method_7960();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(-0.25, 0.5, armor ? 0.05 : 0.12);
			ms.method_22905(0.5F, -0.5F, -0.5F);

			class_1087 model = MiscellaneousModels.INSTANCE.snowflakePendantGem;
			class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);
		}
	}

}
