/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;

public class RingOfChordataItem extends BaubleItem {

	private static final int COST = 3;

	public RingOfChordataItem(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (living.method_5816()) {
			// only activate for one ring at a time
			class_1799 result = EquipmentHandler.findOrEmpty(BotaniaItems.waterRing, living);
			if (result != stack) {
				return;
			}

			if (!living.field_6002.field_9236) {
				if (living instanceof class_1657 player && !ManaItemHandler.instance().requestManaExact(stack, player, COST, true)) {
					onUnequipped(stack, living);
				} else {
					addEffect(living, class_1294.field_5927);
					addEffect(living, class_1294.field_5900);
				}
			}
		} else {
			onUnequipped(stack, living);
		}
	}

	private static void addEffect(class_1309 living, class_1291 effect) {
		class_1293 inst = living.method_6112(effect);
		if (inst == null || (inst.method_5578() == 0 && inst.method_5584() == 1)) {
			class_1293 neweffect = new class_1293(effect, 100, 0, true, true);
			living.method_6092(neweffect);
		}
	}

}
