/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.ManaItemHandler;

public class InvisibilityCloakItem extends BaubleItem {

	public InvisibilityCloakItem(class_1793 props) {
		super(props);
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 living) {
		class_1293 effect = living.method_6112(class_1294.field_5905);
		if (effect != null && effect.method_5578() == -42) {
			living.method_6016(class_1294.field_5905);
		}
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 entity) {
		if (entity instanceof class_1657 player && !player.field_6002.field_9236) {
			int manaCost = 2;
			boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, player, manaCost, true);
			if (!hasMana) {
				onUnequipped(stack, player);
			} else {
				if (player.method_6112(class_1294.field_5905) != null) {
					player.method_6016(class_1294.field_5905);
				}

				player.method_6092(new class_1293(class_1294.field_5905, Integer.MAX_VALUE, -42, true, true));
			}
		}
	}
}
