/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public class GreaterBandOfManaItem extends BandOfManaItem {

	private static final int MAX_MANA = BandOfManaItem.MAX_MANA * 4;

	public GreaterBandOfManaItem(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> stacks) {
		if (method_7877(tab)) {
			stacks.add(new class_1799(this));

			class_1799 full = new class_1799(this);
			setMana(full, MAX_MANA);
			stacks.add(full);
		}
	}

	public static class GreaterManaItemImpl extends ManaItemImpl {
		public GreaterManaItemImpl(class_1799 stack) {
			super(stack);
		}

		@Override
		public int getMaxMana() {
			return MAX_MANA * stack.method_7947();
		}
	}
}
