/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.serverbound.JumpPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_746;

public class CirrusAmuletItem extends BaubleItem {

	private static final Set<class_1657> JUMPING_PLAYERS = Collections.newSetFromMap(new WeakHashMap<>());

	private static int timesJumped;
	private static boolean jumpDown;

	public CirrusAmuletItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		Proxy.INSTANCE.runOnClient(() -> () -> {
			if (living == class_310.method_1551().field_1724) {
				class_746 playerSp = (class_746) living;

				if (playerSp.method_24828()) {
					timesJumped = 0;
				} else {
					if (playerSp.field_3913.field_3904) {
						if (!jumpDown && timesJumped < ((CirrusAmuletItem) stack.method_7909()).getMaxAllowedJumps()) {
							playerSp.method_6043();
							ClientXplatAbstractions.INSTANCE.sendToServer(JumpPacket.INSTANCE);
							timesJumped++;
						}
						jumpDown = true;
					} else {
						jumpDown = false;
					}
				}
			}
		});
	}

	public static void setJumping(class_1657 entity) {
		JUMPING_PLAYERS.add(entity);
	}

	public static boolean popJumping(class_1657 entity) {
		if (entity.field_6002.field_9236) {
			return timesJumped > 0;
		}
		return JUMPING_PLAYERS.remove(entity);
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6174).method_7960();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(-0.3, 0.4, armor ? 0.05 : 0.12);
			ms.method_22905(0.5F, -0.5F, -0.5F);

			class_1087 model = stack.method_31574(BotaniaItems.superCloudPendant)
					? MiscellaneousModels.INSTANCE.nimbusGem
					: MiscellaneousModels.INSTANCE.cirrusGem;
			class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);
		}
	}

	public int getMaxAllowedJumps() {
		return 2;
	}

}
