/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.flower.functional.HeiseiDreamBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.EntityAccessor;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_809;

public class CharmOfTheDivaItem extends BaubleItem {

	public CharmOfTheDivaItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	public static void onEntityDamaged(class_1657 player, class_1297 entity) {
		if (entity instanceof class_1308 target
				&& !entity.field_6002.field_9236
				&& entity.method_5822()
				&& Math.random() < 0.6F) {
			class_1799 amulet = EquipmentHandler.findOrEmpty(BotaniaItems.divaCharm, player);

			if (!amulet.method_7960()) {
				final int cost = 250;
				if (ManaItemHandler.instance().requestManaExact(amulet, player, cost, false)) {
					final int range = 20;

					@SuppressWarnings("unchecked")
					List<class_1569> mobs = (List<class_1569>) (List<?>) player.field_6002.method_8390(class_1297.class, new class_238(target.method_23317() - range, target.method_23318() - range, target.method_23321() - range, target.method_23317() + range, target.method_23318() + range, target.method_23321() + range), Predicates.instanceOf(class_1569.class));
					if (mobs.size() > 1) {
						if (HeiseiDreamBlockEntity.brainwashEntity(target, mobs)) {
							target.method_6025(target.method_6063());
							((EntityAccessor) target).callUnsetRemoved();
							if (target instanceof class_1548) {
								((CreeperAccessor) target).setCurrentFuseTime(2);
							}

							ManaItemHandler.instance().requestManaExact(amulet, player, cost, true);
							player.field_6002.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.divaCharm, class_3419.field_15248, 1F, 1F);
							XplatAbstractions.INSTANCE.sendToTracking(target, new BotaniaEffectPacket(EffectType.DIVA_EFFECT, target.method_23317(), target.method_23318(), target.method_23321(), target.method_5628()));
						}
					}
				}
			}
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			bipedModel.field_3398.method_22703(ms);
			ms.method_22904(0.15, -0.42, -0.35);
			ms.method_22905(0.4F, -0.4F, -0.4F);
			class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315,
					light, class_4608.field_21444, ms, buffers, living.method_5628());
		}
	}
}
