/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Optional;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5632;

public class BandOfManaItem extends BaubleItem {

	protected static final int MAX_MANA = 500000;

	private static final String TAG_MANA = "mana";

	public BandOfManaItem(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> stacks) {
		if (method_7877(tab)) {
			stacks.add(new class_1799(this));

			class_1799 full = new class_1799(this);
			setMana(full, MAX_MANA);
			stacks.add(full);
		}
	}

	@Override
	public Optional<class_5632> method_32346(class_1799 stack) {
		return Optional.of(ManaBarTooltip.fromManaItem(stack));
	}

	protected static void setMana(class_1799 stack, int mana) {
		if (mana > 0) {
			ItemNBTHelper.setInt(stack, TAG_MANA, mana);
		} else {
			ItemNBTHelper.removeEntry(stack, TAG_MANA);
		}
	}

	public static class ManaItemImpl implements ManaItem {
		protected final class_1799 stack;

		public ManaItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public int getMana() {
			return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.method_7947();
		}

		@Override
		public int getMaxMana() {
			return MAX_MANA * stack.method_7947();
		}

		@Override
		public void addMana(int mana) {
			setMana(stack, Math.min(getMana() + mana, getMaxMana()) / stack.method_7947());
		}

		@Override
		public boolean canReceiveManaFromPool(class_2586 pool) {
			return true;
		}

		@Override
		public boolean canReceiveManaFromItem(class_1799 otherStack) {
			return true;
		}

		@Override
		public boolean canExportManaToPool(class_2586 pool) {
			return true;
		}

		@Override
		public boolean canExportManaToItem(class_1799 otherStack) {
			return true;
		}

		@Override
		public boolean isNoExport() {
			return false;
		}
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31569(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return Math.round(13 * ManaBarTooltip.getFractionForDisplay(manaItem));
	}

	@Override
	public int method_31571(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return class_3532.method_15369(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0F, 1.0F, 1.0F);
	}
}
