/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.DamageSourceAccessor;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class TerrasteelHelmItem extends TerrasteelArmorItem implements ManaDiscountArmor, AncientWillContainer {

	public static final String TAG_ANCIENT_WILL = "AncientWill";

	public TerrasteelHelmItem(class_1793 props) {
		super(class_1304.field_6169, props);
	}

	@Override
	public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
		super.onArmorTick(stack, world, player);
		if (!world.field_9236 && hasArmorSet(player)) {
			int food = player.method_7344().method_7586();
			if (food > 0 && food < 18 && player.method_7317() && player.field_6012 % 80 == 0) {
				player.method_6025(1F);
			}
			if (player.field_6012 % 10 == 0) {
				ManaItemHandler.instance().dispatchManaExact(stack, player, 10, true);
			}
		}
	}

	@Override
	public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return hasArmorSet(player) ? 0.2F : 0F;
	}

	@Override
	public void addAncientWill(class_1799 stack, AncientWillType will) {
		ItemNBTHelper.setBoolean(stack, TAG_ANCIENT_WILL + "_" + will.name().toLowerCase(Locale.ROOT), true);
	}

	@Override
	public boolean hasAncientWill(class_1799 stack, AncientWillType will) {
		return hasAncientWill_(stack, will);
	}

	private static boolean hasAncientWill_(class_1799 stack, AncientWillType will) {
		return ItemNBTHelper.getBoolean(stack, TAG_ANCIENT_WILL + "_" + will.name().toLowerCase(Locale.ROOT), false);
	}

	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		super.addArmorSetDescription(stack, list);
		for (AncientWillType type : AncientWillType.values()) {
			if (hasAncientWill(stack, type)) {
				list.add(class_2561.method_43471("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc").method_27692(class_124.field_1080));
			}
		}
	}

	public static boolean hasAnyWill(class_1799 stack) {
		for (AncientWillType type : AncientWillType.values()) {
			if (hasAncientWill_(stack, type)) {
				return true;
			}
		}

		return false;
	}

	public static boolean hasTerraArmorSet(class_1657 player) {
		return ((TerrasteelHelmItem) BotaniaItems.terrasteelHelm).hasArmorSet(player);
	}

	public static float getCritDamageMult(class_1657 player) {
		if (hasTerraArmorSet(player)) {
			class_1799 stack = player.method_6118(class_1304.field_6169);
			if (!stack.method_7960() && stack.method_7909() instanceof TerrasteelHelmItem
					&& hasAncientWill_(stack, AncientWillType.DHAROK)) {
				return 1F + (1F - player.method_6032() / player.method_6063()) * 0.5F;
			}
		}
		return 1.0F;
	}

	public static void onEntityAttacked(class_1282 source, float amount, class_1657 player, class_1309 entity) {
		if (hasTerraArmorSet(player)) {
			class_1799 stack = player.method_6118(class_1304.field_6169);
			if (!stack.method_7960() && stack.method_7909() instanceof TerrasteelHelmItem) {
				if (hasAncientWill_(stack, AncientWillType.AHRIM)) {
					entity.method_6092(new class_1293(class_1294.field_5911, 20, 1));
				}
				if (hasAncientWill_(stack, AncientWillType.GUTHAN)) {
					player.method_6025(amount * 0.25F);
				}
				if (hasAncientWill_(stack, AncientWillType.TORAG)) {
					entity.method_6092(new class_1293(class_1294.field_5909, 60, 1));
				}
				if (hasAncientWill_(stack, AncientWillType.VERAC)) {
					((DamageSourceAccessor) source).botania_setBypassArmor();
				}
				if (hasAncientWill_(stack, AncientWillType.KARIL)) {
					entity.method_6092(new class_1293(class_1294.field_5920, 60, 1));
				}
			}
		}
	}

}
