/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class TerrasteelArmorItem extends ManasteelArmorItem {

	public TerrasteelArmorItem(class_1304 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return ResourcesLib.MODEL_TERRASTEEL_NEW;
	}

	@NotNull
	@Override
	public Multimap<class_1320, class_1322> method_7844(@NotNull class_1304 slot) {
		Multimap<class_1320, class_1322> ret = super.method_7844(slot);
		UUID uuid = new UUID(class_2378.field_11142.method_10221(this).hashCode() + slot.toString().hashCode(), 0);
		if (slot == method_7685()) {
			ret = HashMultimap.create(ret);
			int reduction = method_7686().method_7697(slot);
			ret.put(class_5134.field_23718,
					new class_1322(uuid, "Terrasteel modifier " + type, (double) reduction / 20, class_1322.class_1323.field_6328));
		}
		return ret;
	}

	private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[] {
			new class_1799(BotaniaItems.terrasteelHelm),
			new class_1799(BotaniaItems.terrasteelChest),
			new class_1799(BotaniaItems.terrasteelLegs),
			new class_1799(BotaniaItems.terrasteelBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.get();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		return switch (slot) {
			case field_6169 -> stack.method_31574(BotaniaItems.terrasteelHelm);
			case field_6174 -> stack.method_31574(BotaniaItems.terrasteelChest);
			case field_6172 -> stack.method_31574(BotaniaItems.terrasteelLegs);
			case field_6166 -> stack.method_31574(BotaniaItems.terrasteelBoots);
			default -> false;
		};

	}

	@Override
	public class_5250 getArmorSetName() {
		return class_2561.method_43471("botania.armorset.terrasteel.name");
	}

	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(class_2561.method_43471("botania.armorset.terrasteel.desc0").method_27692(class_124.field_1080));
		list.add(class_2561.method_43471("botania.armorset.terrasteel.desc1").method_27692(class_124.field_1080));
		list.add(class_2561.method_43471("botania.armorset.terrasteel.desc2").method_27692(class_124.field_1080));
	}

	@SoftImplement("IForgeItem")
	public boolean makesPiglinsNeutral(class_1799 stack, class_1309 wearer) {
		return true;
	}
}
