/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.ManaProficiencyArmor;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class ManaweaveHelmItem extends ManaweaveArmorItem implements ManaDiscountArmor, ManaProficiencyArmor {

	private static final int MANA_PER_DAMAGE = 30;

	public ManaweaveHelmItem(class_1793 props) {
		super(class_1304.field_6169, props);
	}

	@Override
	public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return hasArmorSet(player) ? 0.35F : 0F;
	}

	@Override
	public boolean shouldGiveProficiency(class_1799 stack, class_1304 slot, class_1657 player, class_1799 rod) {
		return hasArmorSet(player);
	}

	@Override
	public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
		if (!world.field_9236 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, MANA_PER_DAMAGE * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		return ToolCommons.damageItemIfPossible(stack, amount, entity, MANA_PER_DAMAGE);
	}
}
