/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import com.google.common.base.Suppliers;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ManaweaveArmorItem extends ManasteelArmorItem {

	public ManaweaveArmorItem(class_1304 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getManaweaveArmorMaterial(), props);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return ClientProxy.jingleTheBells ? ResourcesLib.MODEL_MANAWEAVE_NEW_HOLIDAY : ResourcesLib.MODEL_MANAWEAVE_NEW;
	}

	@NotNull
	@Override
	public String method_7866(class_1799 stack) {
		String name = super.method_7866(stack);
		if (XplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
			name = name.replaceAll("manaweave", "santaweave");
		}
		return name;
	}

	private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[] {
			new class_1799(BotaniaItems.manaweaveHelm),
			new class_1799(BotaniaItems.manaweaveChest),
			new class_1799(BotaniaItems.manaweaveLegs),
			new class_1799(BotaniaItems.manaweaveBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.get();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		return switch (slot) {
			case field_6169 -> stack.method_31574(BotaniaItems.manaweaveHelm);
			case field_6174 -> stack.method_31574(BotaniaItems.manaweaveChest);
			case field_6172 -> stack.method_31574(BotaniaItems.manaweaveLegs);
			case field_6166 -> stack.method_31574(BotaniaItems.manaweaveBoots);
			default -> false;
		};

	}

	@Override
	public class_5250 getArmorSetName() {
		return class_2561.method_43471("botania.armorset.manaweave.name");
	}

	@Override
	public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		if (XplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
			list.add(class_2561.method_43471("botaniamisc.santaweaveInfo"));
			list.add(class_2561.method_43470(""));
		}

		super.addInformationAfterShift(stack, world, list, flags);
	}

	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(class_2561.method_43471("botania.armorset.manaweave.desc0").method_27692(class_124.field_1080));
		list.add(class_2561.method_43471("botania.armorset.manaweave.desc1").method_27692(class_124.field_1080));
	}
}
