/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.common.handler.PixieHandler;

public class ElementiumHelmItem extends ElementiumArmorItem implements ManaDiscountArmor {
	public ElementiumHelmItem(class_1793 props) {
		super(class_1304.field_6169, props);
	}

	@NotNull
	@Override
	public Multimap<class_1320, class_1322> method_7844(@NotNull class_1304 slot) {
		Multimap<class_1320, class_1322> ret = super.method_7844(slot);
		if (slot == method_7685()) {
			ret = HashMultimap.create(ret);
			ret.put(PixieHandler.PIXIE_SPAWN_CHANCE, PixieHandler.makeModifier(slot, "Armor modifier", 0.11));
		}
		return ret;
	}

	@Override
	public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return hasArmorSet(player) ? 0.1F : 0F;
	}

}
