/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5328;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BaseBrewItem extends class_1792 implements BrewItem {

	private static final String TAG_BREW_KEY = "brewKey";
	private static final String TAG_SWIGS_LEFT = "swigsLeft";

	private final int swigs;
	private final int drinkSpeed;
	private final Supplier<class_1792> baseItem;

	public BaseBrewItem(class_1793 builder, int swigs, int drinkSpeed, Supplier<class_1792> baseItem) {
		super(builder);
		this.swigs = swigs;
		this.drinkSpeed = drinkSpeed;
		this.baseItem = baseItem;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return drinkSpeed;
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8946;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		return class_5328.method_29282(world, player, hand);
	}

	@NotNull
	@Override
	public class_1799 method_7861(@NotNull class_1799 stack, class_1937 world, class_1309 living) {
		if (!world.field_9236) {
			for (class_1293 effect : getBrew(stack).getPotionEffects(stack)) {
				class_1293 newEffect = new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578(), true, true);
				if (effect.method_5579().method_5561()) {
					effect.method_5579().method_5564(living, living, living, newEffect.method_5578(), 1F);
				} else {
					living.method_6092(newEffect);
				}
			}

			if (world.field_9229.method_43056()) {
				world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), class_3417.field_19149, class_3419.field_15248, 1F, 1F);
			}

			int swigs = getSwigsLeft(stack);
			if (living instanceof class_1657 player && !player.method_31549().field_7477) {
				if (swigs == 1) {
					class_1799 result = getBaseStack();
					if (!player.method_31548().method_7394(result)) {
						return result;
					} else {
						return class_1799.field_8037;
					}
				}

				setSwigsLeft(stack, swigs - 1);
			}
		}

		return stack;
	}

	@Override
	public void method_7850(class_1761 tab, class_2371<class_1799> list) {
		if (method_7877(tab)) {
			for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
				if (brew == BotaniaBrews.fallbackBrew) {
					continue;
				}
				class_1799 stack = new class_1799(this);
				setBrew(stack, brew);
				list.add(stack);
			}
		}
	}

	@NotNull
	@Override
	public class_2561 method_7864(@NotNull class_1799 stack) {
		return class_2561.method_43469(method_7876(), class_2561.method_43471(getBrew(stack).getTranslationKey(stack)),
				class_2561.method_43470(Integer.toString(getSwigsLeft(stack))).method_27692(class_124.field_1067));
	}

	// [VanillaCopy] PotionUtils.addPotionTooltip, with custom effect list
	public static void addPotionTooltip(List<class_1293> list, List<class_2561> lores, float durationFactor) {
		List<Pair<class_1320, class_1322>> list1 = Lists.newArrayList();
		if (list.isEmpty()) {
			lores.add((class_2561.method_43471("effect.none")).method_27692(class_124.field_1080));
		} else {
			for (class_1293 effectinstance : list) {
				class_5250 iformattabletextcomponent = class_2561.method_43471(effectinstance.method_5586());
				class_1291 effect = effectinstance.method_5579();
				Map<class_1320, class_1322> map = effect.method_5565();
				if (!map.isEmpty()) {
					for (Map.Entry<class_1320, class_1322> entry : map.entrySet()) {
						class_1322 attributemodifier = entry.getValue();
						class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectinstance.method_5578(), attributemodifier), attributemodifier.method_6182());
						list1.add(new Pair<>(entry.getKey(), attributemodifier1));
					}
				}

				if (effectinstance.method_5578() > 0) {
					iformattabletextcomponent = class_2561.method_43469("potion.withAmplifier", iformattabletextcomponent, class_2561.method_43471("potion.potency." + effectinstance.method_5578()));
				}

				if (effectinstance.method_5584() > 20) {
					iformattabletextcomponent = class_2561.method_43469("potion.withDuration", iformattabletextcomponent, class_1292.method_5577(effectinstance, durationFactor));
				}

				lores.add(iformattabletextcomponent.method_27692(effect.method_18792().method_18793()));
			}
		}

		if (!list1.isEmpty()) {
			lores.add(class_2561.method_43473());
			lores.add((class_2561.method_43471("potion.whenDrank")).method_27692(class_124.field_1064));

			for (Pair<class_1320, class_1322> pair : list1) {
				class_1322 attributemodifier2 = pair.getSecond();
				double d0 = attributemodifier2.method_6186();
				double d1;
				if (attributemodifier2.method_6182() != class_1322.class_1323.field_6330 && attributemodifier2.method_6182() != class_1322.class_1323.field_6331) {
					d1 = attributemodifier2.method_6186();
				} else {
					d1 = attributemodifier2.method_6186() * 100.0D;
				}

				if (d0 > 0.0D) {
					lores.add((class_2561.method_43469("attribute.modifier.plus." + attributemodifier2.method_6182().method_6191(), class_1799.field_8029.format(d1), class_2561.method_43471(pair.getFirst().method_26830()))).method_27692(class_124.field_1078));
				} else if (d0 < 0.0D) {
					d1 = d1 * -1.0D;
					lores.add((class_2561.method_43469("attribute.modifier.take." + attributemodifier2.method_6182().method_6191(), class_1799.field_8029.format(d1), class_2561.method_43471(pair.getFirst().method_26830()))).method_27692(class_124.field_1061));
				}
			}
		}
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		addPotionTooltip(getBrew(stack).getPotionEffects(stack), list, 1);
	}

	@Override
	public Brew getBrew(class_1799 stack) {
		String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
		return BotaniaAPI.instance().getBrewRegistry().method_10223(class_2960.method_12829(key));
	}

	public static void setBrew(class_1799 stack, @Nullable Brew brew) {
		class_2960 id;
		if (brew != null) {
			id = BotaniaAPI.instance().getBrewRegistry().method_10221(brew);
		} else {
			id = prefix("fallback");
		}
		setBrew(stack, id);
	}

	public static void setBrew(class_1799 stack, class_2960 brew) {
		ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
	}

	@NotNull
	public static String getSubtype(class_1799 stack) {
		return stack.method_7985() ? ItemNBTHelper.getString(stack, TAG_BREW_KEY, "none") : "none";
	}

	public int getSwigs() {
		return swigs;
	}

	public int getSwigsLeft(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, swigs);
	}

	public void setSwigsLeft(class_1799 stack, int swigs) {
		ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
	}

	public class_1799 getBaseStack() {
		return new class_1799(baseItem.get());
	}
}
