/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.block;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_6862;

public class TinyPotatoBlockItem extends class_1747 implements ItemWithBannerPattern {

	private static final Pattern TYPOS = Pattern.compile(
			"(?!^vazkii$)" // Do not match the properly spelled version 
					+ "^v[ao]{1,2}[sz]{0,2}[ak]{1,2}(i){1,2}l{0,2}$",
			Pattern.CASE_INSENSITIVE
	);

	private static final String[] NOT_MY_NAME = {
			"Six letter word just to get me along",
			"It's a intricacy and I'm coding on my mod and I,",
			"I keep fixin', and keepin' it together",
			"People around gotta find something to play now",
			"Holding back, every mod's the same",
			"Don't wanna be a loser",
			"Listen to me, oh no, I don't break anything at all",
			"But with nothing to consider they forget my name",
			"'ame, 'ame, 'ame",
			"They call me Vaskii",
			"They call me Vazki",
			"They call me Voskii",
			"They call me Vazkki",
			"That's not my name",
			"That's not my name",
			"That's not my name",
			"That's not my name"
	};

	private static final String TAG_TICKS = "notMyNameTicks";

	public TinyPotatoBlockItem(class_2248 block, class_1793 props) {
		super(block, props);
	}

	@Override
	public class_6862<class_2582> getBannerPattern() {
		return BotaniaTags.BannerPatterns.PATTERN_ITEM_TINY_POTATO;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 e, int t, boolean idunno) {
		if (!world.field_9236 && e instanceof class_1657 player && e.field_6012 % 30 == 0
				&& TYPOS.matcher(stack.method_7964().getString()).matches()) {
			int ticks = ItemNBTHelper.getInt(stack, TAG_TICKS, 0);
			if (ticks < NOT_MY_NAME.length) {
				player.method_43496(class_2561.method_43470(NOT_MY_NAME[ticks]).method_27692(class_124.field_1061));
				ItemNBTHelper.setInt(stack, TAG_TICKS, ticks + 1);
			}
		}
	}

	public static boolean isEnchantedName(@NotNull class_2561 name) {
		var str = name.getString();
		return str.equals("enchanted") || str.startsWith("enchanted ");
	}

	@Override
	public boolean method_7886(@NotNull class_1799 stack) {
		return super.method_7886(stack) || isEnchantedName(stack.method_7964());
	}

	@SoftImplement("IForgeItem")
	public class_1304 getEquipmentSlot(class_1799 stack) {
		return class_1304.field_6169;
	}

	@SoftImplement("IForgeItem") // TODO implement on fabric
	public boolean canEquip(class_1799 stack, class_1304 armorType, class_1297 entity) {
		return armorType == getEquipmentSlot(stack) && entity instanceof class_1657 player
				&& ContributorList.hasFlower(player.method_7334().getName().toLowerCase(Locale.ROOT));
	}
}
