/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;

public class WorldSeedItem extends class_1792 {

	public WorldSeedItem(class_1793 builder) {
		super(builder);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);

		class_2338 coords = world.method_43126();
		boolean inRange = coords.method_10268(player.method_23317(), player.method_23318(), player.method_23321()) <= 24 * 24;
		if (world.method_27983() == class_1937.field_25179 && !inRange) {
			if (!world.field_9236) {
				player.method_36457(0F);
				player.method_36456(0F);
				player.method_5859(coords.method_10263() + 0.5, coords.method_10264() + 0.5, coords.method_10260() + 0.5);

				while (!world.method_8587(player, player.method_5829())) {
					player.method_5859(player.method_23317(), player.method_23318() + 1, player.method_23321());
				}

				world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.worldSeedTeleport, class_3419.field_15248, 1F, 1F);
				SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.25F, 1F, 0.25F, 10);
				((class_3218) world).method_14199(data, player.method_23317(), player.method_23318() + player.method_17682() / 2, player.method_23321(), 50, player.method_17681() / 8, player.method_17682() / 4, player.method_17681() / 8, 0);
				stack.method_7934(1);
			}

			return class_1271.method_29237(stack, world.method_8608());
		}

		return new class_1271<>(class_1269.field_5811, stack);
	}

}
