/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.util.*;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class WandOfTheForestItem extends class_1792 {

	private static final String TAG_COLOR1 = "color1";
	private static final String TAG_COLOR2 = "color2";
	private static final String TAG_BOUND_TILE_X = "boundTileX";
	private static final String TAG_BOUND_TILE_Y = "boundTileY";
	private static final String TAG_BOUND_TILE_Z = "boundTileZ";
	private static final String TAG_BIND_MODE = "bindMode";

	public final class_124 modeChatFormatting;

	public WandOfTheForestItem(class_124 formatting, class_1792.class_1793 builder) {
		super(builder);
		this.modeChatFormatting = formatting;
	}

	private static boolean tryCompleteBinding(class_2338 src, class_1799 stack, class_1838 ctx) {
		class_2338 dest = ctx.method_8037();
		if (!dest.equals(src)) {
			setBindingAttempt(stack, Bound.UNBOUND_POS);

			class_2586 srcTile = ctx.method_8045().method_8321(src);
			if (srcTile instanceof WandBindable bindable) {
				if (bindable.bindTo(ctx.method_8036(), stack, dest, ctx.method_8038())) {
					doParticleBeamWithOffset(ctx.method_8045(), src, dest);
					setBindingAttempt(stack, Bound.UNBOUND_POS);
				}
				return true;
			}
		}
		return false;
	}

	private static boolean tryFormEnchanter(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350.class_2351 axis = ManaEnchanterBlockEntity.canEnchanterExist(world, pos);

		if (axis != null) {
			if (!world.field_9236) {
				world.method_8501(pos, BotaniaBlocks.enchanter.method_9564().method_11657(BotaniaStateProperties.ENCHANTER_DIRECTION, axis));
				world.method_8396(null, pos, BotaniaSounds.enchanterForm, class_3419.field_15245, 1F, 1F);
				PlayerHelper.grantCriterion((class_3222) ctx.method_8036(), prefix("main/enchanter_make"), "code_triggered");
			} else {
				for (int i = 0; i < 50; i++) {
					float red = (float) Math.random();
					float green = (float) Math.random();
					float blue = (float) Math.random();

					double x = (Math.random() - 0.5) * 6;
					double y = (Math.random() - 0.5) * 6;
					double z = (Math.random() - 0.5) * 6;

					float velMul = 0.07F;

					float motionx = (float) -x * velMul;
					float motiony = (float) -y * velMul;
					float motionz = (float) -z * velMul;
					WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, red, green, blue);
					world.method_8406(data, pos.method_10263() + 0.5 + x, pos.method_10264() + 0.5 + y, pos.method_10260() + 0.5 + z, motionx, motiony, motionz);
				}
			}

			return true;
		}
		return false;
	}

	private static boolean tryCompletePistonRelayBinding(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1657 player = ctx.method_8036();

		class_4208 bindPos = ((ForceRelayBlock) BotaniaBlocks.pistonRelay).activeBindingAttempts.get(player.method_5667());
		if (bindPos != null && bindPos.method_19442() == world.method_27983()) {
			((ForceRelayBlock) BotaniaBlocks.pistonRelay).activeBindingAttempts.remove(player.method_5667());
			ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get(world);
			data.mapping.put(bindPos.method_19446(), pos.method_10062());
			data.method_80();

			XplatAbstractions.INSTANCE.sendToNear(world, pos, new BotaniaEffectPacket(EffectType.PARTICLE_BEAM,
					bindPos.method_19446().method_10263() + 0.5, bindPos.method_19446().method_10264() + 0.5, bindPos.method_19446().method_10260() + 0.5,
					pos.method_10263(), pos.method_10264(), pos.method_10260()));

			world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.ding, class_3419.field_15248, 1F, 1F);
			return true;
		}
		return false;
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1799 stack = ctx.method_8041();
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();
		class_2338 pos = ctx.method_8037();
		class_2680 state = world.method_8320(pos);
		class_2248 block = state.method_26204();
		class_2350 side = ctx.method_8038();
		Optional<class_2338> boundPos = getBindingAttempt(stack);

		if (player == null) {
			return class_1269.field_5811;
		}

		if (player.method_21823()) {
			if (boundPos.filter(loc -> tryCompleteBinding(loc, stack, ctx)).isPresent()) {
				return class_1269.field_5812;
			}

			if (player.method_7343(pos, side, stack)
					&& (!(block instanceof class_2288) || player.method_7338())) {
				class_2680 newState = manipulateBlockstate(state, side);
				if (newState != state) {
					world.method_8501(pos, newState);
					ctx.method_8045().method_8396(
							ctx.method_8036(), ctx.method_8037(), newState.method_26204().method_9573(newState).method_10598(),
							class_3419.field_15245, 1F, 1F
					);
					return class_1269.field_5812;
				}
			}
		}

		if (state.method_27852(class_2246.field_10441) && BotaniaConfig.common().enchanterEnabled() && tryFormEnchanter(ctx)) {
			return class_1269.field_5812;
		}

		class_2586 tile = world.method_8321(pos);

		if (getBindMode(stack) && tile instanceof WandBindable bindable && player.method_5715() && bindable.canSelect(player, stack, pos, side)) {
			if (boundPos.filter(pos::equals).isPresent()) {
				setBindingAttempt(stack, Bound.UNBOUND_POS);
			} else {
				setBindingAttempt(stack, pos);
			}

			if (world.field_9236) {
				player.method_5783(BotaniaSounds.ding, 0.11F, 1F);
			}

			return class_1269.field_5812;
		} else {
			var wandable = XplatAbstractions.INSTANCE.findWandable(world, pos, state, tile);
			if (wandable != null) {
				return wandable.onUsedByWand(player, stack, side) ? class_1269.field_5812 : class_1269.field_5814;
			}
		}

		if (!world.field_9236 && getBindMode(stack) && tryCompletePistonRelayBinding(ctx)) {
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	private static class_2680 manipulateBlockstate(class_2680 old, class_2350 side) {
		if (old.method_26164(BotaniaTags.Blocks.UNWANDABLE)) {
			return old;
		}

		class_2746 directionPropertyFromSide = class_2429.field_11329.get(side);
		if (old.method_28498(directionPropertyFromSide)) {
			boolean oldValue = old.method_11654(directionPropertyFromSide);
			return old.method_11657(directionPropertyFromSide, !oldValue);
		}

		for (class_2769<?> prop : old.method_28501()) {
			if (prop.method_11899().equals("facing") && prop.method_11902() == class_2350.class) {
				@SuppressWarnings("unchecked")
				class_2769<class_2350> facingProp = (class_2769<class_2350>) prop;

				class_2350 oldDir = old.method_11654(facingProp);
				class_2350 newDir = rotateAround(oldDir, side.method_10166());
				if (oldDir != newDir && facingProp.method_11898().contains(newDir)) {
					return old.method_11657(facingProp, newDir);
				}
			}
		}

		return old.method_26186(class_2470.field_11463);
	}

	private static class_2350 rotateAround(class_2350 old, class_2350.class_2351 axis) {
		return switch (axis) {
			case field_11048 -> switch (old) {
					case field_11033 -> class_2350.field_11035;
					case field_11035 -> class_2350.field_11036;
					case field_11036 -> class_2350.field_11043;
					case field_11043 -> class_2350.field_11033;
					default -> old;
				};
			case field_11052 -> switch (old) {
					case field_11043 -> class_2350.field_11034;
					case field_11034 -> class_2350.field_11035;
					case field_11035 -> class_2350.field_11039;
					case field_11039 -> class_2350.field_11043;
					default -> old;
				};
			case field_11051 -> switch (old) {
					case field_11033 -> class_2350.field_11039;
					case field_11039 -> class_2350.field_11036;
					case field_11036 -> class_2350.field_11034;
					case field_11034 -> class_2350.field_11033;
					default -> old;
				};
		};
	}

	public static void doParticleBeamWithOffset(class_1937 world, class_2338 orig, class_2338 end) {
		class_243 origOffset = world.method_8320(orig).method_26226(world, orig);
		class_243 vorig = new class_243(orig.method_10263() + origOffset.method_10216() + 0.5, orig.method_10264() + origOffset.method_10214() + 0.5, orig.method_10260() + origOffset.method_10215() + 0.5);
		class_243 endOffset = world.method_8320(end).method_26226(world, end);
		class_243 vend = new class_243(end.method_10263() + endOffset.method_10216() + 0.5, end.method_10264() + endOffset.method_10214() + 0.5, end.method_10260() + endOffset.method_10215() + 0.5);
		doParticleBeam(world, vorig, vend);
	}

	public static void doParticleBeam(class_1937 world, class_243 orig, class_243 end) {
		if (!world.field_9236) {
			return;
		}

		class_243 diff = end.method_1020(orig);
		class_243 movement = diff.method_1029().method_1021(0.05);
		int iters = (int) (diff.method_1033() / movement.method_1033());
		float huePer = 1F / iters;
		float hueSum = (float) Math.random();

		class_243 currentPos = orig;
		for (int i = 0; i < iters; i++) {
			float hue = i * huePer + hueSum;
			int color = class_3532.method_15369(class_3532.method_22450(hue), 1F, 1F);
			float r = (color >> 16 & 0xFF) / 255F;
			float g = (color >> 8 & 0xFF) / 255F;
			float b = (color & 0xFF) / 255F;

			SparkleParticleData data = SparkleParticleData.noClip(0.5F, r, g, b, 4);
			Proxy.INSTANCE.addParticleForceNear(world, data, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 0, 0, 0);
			currentPos = currentPos.method_1019(movement);
		}
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		getBindingAttempt(stack).ifPresent(coords -> {
			class_2586 tile = world.method_8321(coords);
			if (!(tile instanceof WandBindable)) {
				setBindingAttempt(stack, Bound.UNBOUND_POS);
			}
		});
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.method_21823()) {
			if (!world.field_9236) {
				setBindMode(stack, !getBindMode(stack));
			} else {
				player.method_5783(BotaniaSounds.ding, 0.1F, 1F);
			}
		}

		return class_1271.method_22427(stack);
	}

	@Override
	public void method_7850(@NotNull class_1761 group, @NotNull class_2371<class_1799> stacks) {
		if (method_7877(group)) {
			stacks.add(setColors(new class_1799(this), 0, 0));
			List<Pair<Integer, Integer>> colorPairs = Arrays.asList(
					new Pair<>(0, 3), // White + Light Blue
					new Pair<>(0, 6), // White + Pink
					new Pair<>(3, 6), // Light Blue + Pink
					new Pair<>(10, 11), // Purple + Blue
					new Pair<>(14, 14), // Red
					new Pair<>(11, 11), // Blue
					new Pair<>(1, 1), // Orange
					new Pair<>(15, 15), // Black
					new Pair<>(7, 8), // Gray + Light Gray
					new Pair<>(6, 7), // Pink + Gray
					new Pair<>(4, 5), // Yellow + Lime
					new Pair<>(0, 15) // White + Black
			);
			Collections.shuffle(colorPairs);
			for (int i = 0; i < 7; i++) {
				Pair<Integer, Integer> pair = colorPairs.get(i);
				if (Math.random() < 0.5) {
					pair = new Pair<>(pair.getSecond(), pair.getFirst());
				}
				stacks.add(setColors(new class_1799(this), pair.getFirst(), pair.getSecond()));
			}
		}
	}

	@Override
	public class_2561 method_7864(@NotNull class_1799 stack) {
		class_2561 mode = class_2561.method_43470(" (")
				.method_10852(class_2561.method_43471(getModeString(stack)).method_27692(modeChatFormatting))
				.method_27693(")");
		return super.method_7864(stack).method_27662().method_10852(mode);
	}

	public static class_1799 setColors(class_1799 wand, int color1, int color2) {
		ItemNBTHelper.setInt(wand, TAG_COLOR1, color1);
		ItemNBTHelper.setInt(wand, TAG_COLOR2, color2);

		return wand;
	}

	public static int getColor1(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
	}

	public static int getColor2(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
	}

	public static void setBindingAttempt(class_1799 stack, class_2338 pos) {
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.method_10263());
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.method_10264());
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.method_10260());
	}

	public static Optional<class_2338> getBindingAttempt(class_1799 stack) {
		int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
		int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, Integer.MIN_VALUE);
		int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
		return y == Integer.MIN_VALUE ? Optional.empty() : Optional.of(new class_2338(x, y, z));
	}

	public static boolean getBindMode(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
	}

	public static void setBindMode(class_1799 stack, boolean bindMode) {
		ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
	}

	public static String getModeString(class_1799 stack) {
		return "botaniamisc.wandMode." + (getBindMode(stack) ? "bind" : "function");
	}

	public static class CoordBoundItemImpl implements CoordBoundItem {
		private final class_1799 stack;

		public CoordBoundItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Nullable
		@Override
		public class_2338 getBinding(class_1937 world) {
			Optional<class_2338> bound = getBindingAttempt(stack);
			if (bound.isPresent()) {
				return bound.get();
			}

			var pos = ClientProxy.INSTANCE.getClientHit();
			if (pos instanceof class_3965 bHit && pos.method_17783() == class_239.class_240.field_1332) {
				class_2586 tile = world.method_8321(bHit.method_17777());
				if (tile instanceof Bound boundTile) {
					return boundTile.getBinding();
				}
			}

			return null;
		}
	}

}
