/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5632;

public class ManaTabletItem extends class_1792 {

	public static final int MAX_MANA = 500000;

	private static final String TAG_MANA = "mana";
	private static final String TAG_CREATIVE = "creative";
	private static final String TAG_ONE_USE = "oneUse";

	public ManaTabletItem(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> stacks) {
		if (method_7877(tab)) {
			stacks.add(new class_1799(this));

			class_1799 fullPower = new class_1799(this);
			setMana(fullPower, MAX_MANA);
			stacks.add(fullPower);

			class_1799 creative = new class_1799(this);
			setMana(creative, MAX_MANA);
			setStackCreative(creative);
			stacks.add(creative);
		}
	}

	@NotNull
	@Override
	public class_1814 method_7862(@NotNull class_1799 stack) {
		return isStackCreative(stack) ? class_1814.field_8904 : super.method_7862(stack);
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		if (isStackCreative(stack)) {
			stacks.add(class_2561.method_43471("botaniamisc.creative").method_27692(class_124.field_1080));
		}
	}

	@Override
	public Optional<class_5632> method_32346(class_1799 stack) {
		return Optional.of(ManaBarTooltip.fromManaItem(stack));
	}

	protected static void setMana(class_1799 stack, int mana) {
		if (mana > 0) {
			ItemNBTHelper.setInt(stack, TAG_MANA, mana);
		} else {
			ItemNBTHelper.removeEntry(stack, TAG_MANA);
		}
	}

	public static void setStackCreative(class_1799 stack) {
		ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
	}

	public static boolean isStackCreative(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
	}

	public static class ManaItemImpl implements ManaItem {
		private final class_1799 stack;

		public ManaItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public int getMana() {
			if (isStackCreative(stack)) {
				return getMaxMana();
			}
			return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.method_7947();
		}

		@Override
		public int getMaxMana() {
			return (isStackCreative(stack) ? MAX_MANA + 1000 : MAX_MANA) * stack.method_7947();
		}

		@Override
		public void addMana(int mana) {
			if (!isStackCreative(stack)) {
				setMana(stack, Math.min(getMana() + mana, getMaxMana()) / stack.method_7947());
			}
		}

		@Override
		public boolean canReceiveManaFromPool(class_2586 pool) {
			return !ItemNBTHelper.getBoolean(stack, TAG_ONE_USE, false);
		}

		@Override
		public boolean canReceiveManaFromItem(class_1799 otherStack) {
			return !isStackCreative(stack);
		}

		@Override
		public boolean canExportManaToPool(class_2586 pool) {
			return true;
		}

		@Override
		public boolean canExportManaToItem(class_1799 otherStack) {
			return true;
		}

		@Override
		public boolean isNoExport() {
			return false;
		}
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return !isStackCreative(stack);
	}

	@Override
	public int method_31569(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return Math.round(13 * ManaBarTooltip.getFractionForDisplay(manaItem));
	}

	@Override
	public int method_31571(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return class_3532.method_15369(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0F, 1.0F, 1.0F);
	}
}
