/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.helper.PlayerHelper;

import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class LifeAggregatorItem extends class_1792 {

	private static final String TAG_SPAWNER = "spawner";
	private static final String TAG_SPAWN_DATA = "SpawnData";
	private static final String TAG_ID = "id";

	public LifeAggregatorItem(class_1793 props) {
		super(props);
	}

	@Nullable
	private static class_2960 getEntityId(class_1799 stack) {
		class_2487 tag = stack.method_7941(TAG_SPAWNER);
		if (tag != null && tag.method_10545(TAG_SPAWN_DATA)) {
			tag = tag.method_10562(TAG_SPAWN_DATA);
			var spawnData = class_1952.field_34460.parse(class_2509.field_11560, tag);
			return spawnData.result()
					.filter(sd -> sd.method_38093().method_10545(TAG_ID))
					.map(sd -> class_2960.method_12829(sd.method_38093().method_10558(TAG_ID)))
					.orElse(null);
		}

		return null;
	}

	public static boolean hasData(class_1799 stack) {
		return getEntityId(stack) != null;
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> infoList, class_1836 flags) {
		class_2960 id = getEntityId(stack);
		if (id != null) {
			class_2378.field_11145.method_17966(id).ifPresent(type -> infoList.add(type.method_5897()));
		}
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		if (getEntityId(ctx.method_8041()) == null) {
			return captureSpawner(ctx)
					? class_1269.method_29236(ctx.method_8045().method_8608())
					: class_1269.field_5811;
		} else {
			return placeSpawner(ctx);
		}
	}

	private class_1269 placeSpawner(class_1838 ctx) {
		class_1799 useStack = new class_1799(class_2246.field_10260);
		Pair<class_1269, class_2338> res = PlayerHelper.substituteUseTrackPos(ctx, useStack);

		if (res.getFirst().method_23665()) {
			class_1937 world = ctx.method_8045();
			class_2338 pos = res.getSecond();
			class_1799 mover = ctx.method_8041();

			if (!world.field_9236) {
				if (ctx.method_8036() != null) {
					ctx.method_8036().method_20236(ctx.method_20287());
				}
				mover.method_7934(1);

				class_2586 te = world.method_8321(pos);
				if (te instanceof class_2636) {
					class_2487 spawnerTag = ctx.method_8041().method_7941(TAG_SPAWNER).method_10553();
					spawnerTag.method_10569("x", pos.method_10263());
					spawnerTag.method_10569("y", pos.method_10264());
					spawnerTag.method_10569("z", pos.method_10260());
					te.method_11014(spawnerTag);
				}
			} else {
				for (int i = 0; i < 100; i++) {
					SparkleParticleData data = SparkleParticleData.sparkle(0.45F + 0.2F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), 6);
					world.method_8406(data, pos.method_10263() + Math.random(), pos.method_10264() + Math.random(), pos.method_10260() + Math.random(), 0, 0, 0);
				}
			}
		}

		return res.getFirst();
	}

	private boolean captureSpawner(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1799 stack = ctx.method_8041();
		class_1657 player = ctx.method_8036();

		if (world.method_8320(pos).method_27852(class_2246.field_10260)) {
			if (!world.field_9236) {
				class_2586 te = world.method_8321(pos);
				stack.method_7948().method_10566(TAG_SPAWNER, te.method_38242());
				world.method_22352(pos, false);
				if (player != null) {
					player.method_7357().method_7906(this, 20);
					if (player instanceof class_3222 serverPlayer) {
						UseItemSuccessTrigger.INSTANCE.trigger(serverPlayer, stack, serverPlayer.method_14220(),
								pos.method_10263(), pos.method_10264(), pos.method_10260());
					}
					player.method_20236(ctx.method_20287());
				}
			} else {
				for (int i = 0; i < 50; i++) {
					float red = (float) Math.random();
					float green = (float) Math.random();
					float blue = (float) Math.random();
					WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.1F + 0.05F, red, green, blue);
					world.method_8406(data, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, (float) (Math.random() - 0.5F) * 0.15F, (float) (Math.random() - 0.5F) * 0.15F, (float) (Math.random() - 0.5F) * 0.15F);
				}
			}
			return true;
		} else {
			return false;
		}
	}
}
