/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.patchouli.api.PatchouliAPI;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6862;

public class LexicaBotaniaItem extends class_1792 implements ItemWithBannerPattern {

	public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

	public LexicaBotaniaItem(class_1793 settings) {
		super(settings);
	}

	public static boolean isOpen() {
		return class_2378.field_11142.method_10221(BotaniaItems.lexicon).equals(PatchouliAPI.get().getOpenBookGui());
	}

	@Override
	public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> list) {
		if (method_7877(tab)) {
			list.add(new class_1799(this));
			class_1799 creative = new class_1799(this);
			creative.method_7948().method_10556(TAG_ELVEN_UNLOCK, true);
			list.add(creative);
		}
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
		tooltip.add(getEdition().method_27661().method_27692(class_124.field_1080));
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
		class_1799 stack = playerIn.method_5998(handIn);

		if (playerIn instanceof class_3222 player) {
			UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.method_14220(), player.method_23317(), player.method_23318(), player.method_23321());
			PatchouliAPI.get().openBookGUI(player, class_2378.field_11142.method_10221(this));
			playerIn.method_5783(BotaniaSounds.lexiconOpen, 1F, (float) (0.7 + Math.random() * 0.4));
		}

		return class_1271.method_29237(stack, worldIn.method_8608());
	}

	public static class_2561 getEdition() {
		try {
			return PatchouliAPI.get().getSubtitle(class_2378.field_11142.method_10221(BotaniaItems.lexicon));
		} catch (IllegalArgumentException e) {
			return class_2561.method_43470(""); // TODO Adjust Patchouli because first search tree creation is too early to get the edition
		}
	}

	public static class_2561 getTitle(class_1799 stack) {
		class_2561 title = stack.method_7964();

		String akashicTomeNBT = "akashictome:displayName";
		if (stack.method_7985() && stack.method_7969().method_10545(akashicTomeNBT)) {
			title = class_2561.class_2562.method_10877(stack.method_7969().method_10558(akashicTomeNBT));
		}

		return title;
	}

	public static boolean isElven(class_1799 stack) {
		return stack.method_7985() && stack.method_7969().method_10577(TAG_ELVEN_UNLOCK);
	}

	// Random item to expose this as public
	public static class_3965 doRayTrace(class_1937 world, class_1657 player, class_3959.class_242 fluidMode) {
		return class_1792.method_7872(world, player, fluidMode);
	}

	@Override
	public class_6862<class_2582> getBannerPattern() {
		return BotaniaTags.BannerPatterns.PATTERN_ITEM_LEXICON;
	}
}
